/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Arrays;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.ConstraintViolationKernelException;
import org.neo4j.kernel.api.LabelNotFoundKernelException;
import org.neo4j.kernel.api.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.StatementContext;

class IndexDefinitionImpl
implements IndexDefinition {
    private final Label label;
    private final String propertyKey;
    private final ThreadToStatementContextBridge ctxProvider;

    public IndexDefinitionImpl(ThreadToStatementContextBridge ctxProvider, Label label, String propertyKey) {
        this.ctxProvider = ctxProvider;
        this.label = label;
        this.propertyKey = propertyKey;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return Arrays.asList(this.propertyKey);
    }

    @Override
    public void drop() {
        StatementContext context = this.ctxProvider.getCtxForWriting();
        try {
            context.dropIndexRule(context.getIndexRule(context.getLabelId(this.label.name()), context.getPropertyKeyId(this.propertyKey)));
        }
        catch (ConstraintViolationKernelException e) {
            throw new ConstraintViolationException(String.format("Unable to drop index on label `%s` for property %s.", this.label.name(), this.propertyKey), e);
        }
        catch (LabelNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Mattias", "Label " + this.label.name() + " should exist here");
        }
        catch (PropertyKeyNotFoundException e) {
            throw new ThisShouldNotHappenError("Mattias", "Property " + this.propertyKey + " should exist here");
        }
        catch (SchemaRuleNotFoundException e) {
            throw new ConstraintViolationException(String.format("Unable to drop index on label `%s` for property %s.", this.label.name(), this.propertyKey), e);
        }
        finally {
            context.close();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.label.name().hashCode();
        result = 31 * result + this.propertyKey.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexDefinitionImpl other = (IndexDefinitionImpl)obj;
        if (!this.label.name().equals(other.label.name())) {
            return false;
        }
        return this.propertyKey.equals(other.propertyKey);
    }

    public String toString() {
        return "IndexDefinition[label:" + this.label + ", on:" + this.propertyKey + "]";
    }
}

