/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.ClosableIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.LinesOfFileIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public abstract class IteratorUtil {
    public static Function<Enum, String> ENUM_NAME = new Function<Enum, String>(){

        @Override
        public String apply(Enum from) {
            return from.name();
        }
    };
    private static final ResourceIterator EMPTY_ITERATOR = new ResourceIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    };
    private static final Closeable EMPTY_CLOSEABLE = new Closeable(){

        @Override
        public void close() throws IOException {
        }
    };

    public static <T> T firstOrNull(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> T first(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.firstOrNull(iterator));
    }

    public static <T> T lastOrNull(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T last(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.lastOrNull(iterator));
    }

    public static <T> T singleOrNull(Iterator<T> iterator) {
        return IteratorUtil.single(iterator, null);
    }

    public static <T> T single(Iterator<T> iterator) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.singleOrNull(iterator));
    }

    public static <T> T fromEnd(Iterator<T> iterator, int n) {
        return IteratorUtil.assertNotNull(iterator, IteratorUtil.fromEndOrNull(iterator, n));
    }

    public static <T> T fromEndOrNull(Iterator<T> iterator, int n) {
        ArrayDeque<T> trail = new ArrayDeque<T>(n);
        while (iterator.hasNext()) {
            if (trail.size() > n) {
                trail.removeLast();
            }
            trail.addFirst(iterator.next());
        }
        return trail.size() == n + 1 ? (T)trail.getLast() : null;
    }

    public static boolean iteratorsEqual(Iterator<?> first, Iterator<?> other) {
        while (first.hasNext() && other.hasNext()) {
            if (first.next().equals(other.next())) continue;
            return false;
        }
        return first.hasNext() == other.hasNext();
    }

    private static <T> T assertNotNull(Iterator<T> iterator, T result) {
        if (result == null) {
            throw new NoSuchElementException("No element found in " + iterator);
        }
        return result;
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        return IteratorUtil.firstOrNull(iterable.iterator());
    }

    public static <T> T first(Iterable<T> iterable) {
        return IteratorUtil.first(iterable.iterator());
    }

    public static <T> T lastOrNull(Iterable<T> iterable) {
        return IteratorUtil.lastOrNull(iterable.iterator());
    }

    public static <T> T last(Iterable<T> iterable) {
        return IteratorUtil.last(iterable.iterator());
    }

    public static <T> T singleOrNull(Iterable<T> iterable) {
        return IteratorUtil.singleOrNull(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable) {
        return IteratorUtil.single(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable, T itemIfNone) {
        return IteratorUtil.single(iterable.iterator(), itemIfNone);
    }

    public static <T> T single(Iterator<T> iterator, T itemIfNone) {
        T result;
        T t = result = iterator.hasNext() ? iterator.next() : itemIfNone;
        if (iterator.hasNext()) {
            throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the second element is '" + iterator.next() + "'");
        }
        return result;
    }

    public static <T> T fromEndOrNull(Iterable<T> iterable, int countFromEnd) {
        return IteratorUtil.fromEndOrNull(iterable.iterator(), countFromEnd);
    }

    public static <T> T fromEnd(Iterable<T> iterable, int n) {
        return IteratorUtil.fromEnd(iterable.iterator(), n);
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterator<T> iterator, C collection) {
        while (iterator.hasNext()) {
            IteratorUtil.addUnique(collection, iterator.next());
        }
        return collection;
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterable<T> iterable, C collection) {
        return IteratorUtil.addToCollection(iterable.iterator(), collection);
    }

    public static <C extends Collection<T>, T> C addToCollectionUnique(Iterable<T> iterable, C collection) {
        return IteratorUtil.addToCollectionUnique(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> loop(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> Iterable<T> asIterable(Iterator<T> iterator) {
        return IteratorUtil.loop(iterator);
    }

    public static <T> int count(Iterator<T> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }

    public static <T> int count(Iterable<T> iterable) {
        return IteratorUtil.count(iterable.iterator());
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new ArrayList());
    }

    public static <T> Collection<T> asCollection(Iterator<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new ArrayList());
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return IteratorUtil.addToCollection(iterable, new HashSet());
    }

    public static <T> Set<T> asSet(Iterator<T> iterator) {
        return IteratorUtil.addToCollection(iterator, new HashSet());
    }

    public static <T> Set<T> asUniqueSet(Iterable<T> iterable) {
        return IteratorUtil.addToCollectionUnique(iterable, new HashSet());
    }

    public static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <T> Set<T> asUniqueSet(T ... items) {
        HashSet set = new HashSet();
        for (T item : items) {
            IteratorUtil.addUnique(set, item);
        }
        return set;
    }

    public static <T> Set<T> asUniqueSet(Iterator<T> items) {
        HashSet set = new HashSet();
        while (items.hasNext()) {
            IteratorUtil.addUnique(set, items.next());
        }
        return set;
    }

    public static Set<String> asEnumNameSet(Iterable<Enum> enums) {
        return IteratorUtil.asSet(Iterables.map(ENUM_NAME, enums));
    }

    public static <E extends Enum<E>> Set<String> asEnumNameSet(Class<E> clazz) {
        return IteratorUtil.asSet(Iterables.map(ENUM_NAME, EnumSet.allOf(clazz)));
    }

    public static ClosableIterable<String> asIterable(final File file) {
        return new ClosableIterable<String>(){
            private ClosableIterator<String> mostRecentIterator;

            @Override
            public Iterator<String> iterator() {
                try {
                    if (this.mostRecentIterator != null) {
                        this.mostRecentIterator.close();
                    }
                    this.mostRecentIterator = IteratorUtil.asIterator(file);
                    return this.mostRecentIterator;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() {
                if (this.mostRecentIterator != null) {
                    this.mostRecentIterator.close();
                }
            }
        };
    }

    public static ClosableIterator<String> asIterator(File file) throws IOException {
        return new LinesOfFileIterator(file);
    }

    public static <T> void streamToFile(Iterable<T> iterable, File file, String encoding) throws IOException {
        IteratorUtil.streamToFile(iterable.iterator(), file, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void streamToFile(Iterator<T> iterator, File file, String encoding) throws IOException {
        if (file.exists()) {
            throw new IOException("File '" + file + "' already exists");
        }
        PrintStream out = null;
        try {
            out = new PrintStream(file, encoding);
            while (iterator.hasNext()) {
                out.println(iterator.next().toString());
            }
        }
        catch (Throwable throwable) {
            IteratorUtil.safeClose(out);
            throw throwable;
        }
        IteratorUtil.safeClose(out);
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Iterable<Long> asIterable(final long ... array) {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return IteratorUtil.asIterator(array);
            }
        };
    }

    public static Iterator<Long> asIterator(final long ... array) {
        return new PrefetchingIterator<Long>(){
            private int index;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Long fetchNextOrNull() {
                try {
                    Long l = this.index < array.length ? Long.valueOf(array[this.index]) : null;
                    return l;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static <T> Iterator<T> asIterator(final T ... array) {
        return new PrefetchingIterator<T>(){
            private int index;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected T fetchNextOrNull() {
                try {
                    Object object = this.index < array.length ? array[this.index] : null;
                    return object;
                }
                finally {
                    ++this.index;
                }
            }
        };
    }

    public static <T> ResourceIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> ResourceIterator<T> withResource(Iterator<T> iterator, Closeable closeable) {
        return new ResourceClosingIterator<T>(closeable, iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean contains(Iterator<T> iterator, T item) {
        try {
            for (T element : IteratorUtil.loop(iterator)) {
                if (!(item == null ? element == null : item.equals(element))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (iterator instanceof ResourceIterator) {
                ((ResourceIterator)iterator).close();
            }
        }
    }

    private static class ResourceClosingIterator<T>
    implements ResourceIterator<T> {
        private Closeable closeable;
        private final Iterator<T> iterator;

        ResourceClosingIterator(Closeable closeable, Iterator<T> iterator) {
            this.closeable = closeable;
            this.iterator = iterator;
        }

        @Override
        public void close() {
            try {
                this.closeable.close();
                this.closeable = EMPTY_CLOSEABLE;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.iterator.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public T next() {
            try {
                return this.iterator.next();
            }
            catch (NoSuchElementException e) {
                this.close();
                throw e;
            }
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

