/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Collections;
import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class CombiningIterator<T>
extends PrefetchingIterator<T> {
    private Iterator<? extends Iterator<T>> iterators;
    private Iterator<T> currentIterator;

    public CombiningIterator(Iterable<? extends Iterator<T>> iterators) {
        this(iterators.iterator());
    }

    public CombiningIterator(Iterator<? extends Iterator<T>> iterators) {
        this.iterators = iterators;
    }

    public CombiningIterator(T first, Iterator<T> rest) {
        this(Collections.emptyList());
        this.hasFetchedNext = true;
        this.nextObject = first;
        this.currentIterator = rest;
    }

    @Override
    protected T fetchNextOrNull() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            while (this.iterators.hasNext()) {
                this.currentIterator = this.iterators.next();
                if (!this.currentIterator.hasNext()) continue;
            }
        }
        return this.currentIterator != null && this.currentIterator.hasNext() ? (T)this.currentIterator.next() : null;
    }

    protected Iterator<T> currentIterator() {
        return this.currentIterator;
    }
}

