/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.net.URI;

public class HostnamePort {
    private final String host;
    private final int[] ports;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HostnamePort(String hostnamePort) throws IllegalArgumentException {
        String[] parts = hostnamePort.split(":");
        if (parts.length == 1) {
            this.host = this.zeroLengthMeansNull(parts[0]);
            this.ports = new int[]{0, 0};
            return;
        } else {
            if (parts.length != 2) throw new IllegalArgumentException(hostnamePort);
            this.host = this.zeroLengthMeansNull(parts[0]);
            String[] portStrings = parts[1].split("-");
            this.ports = new int[2];
            if (portStrings.length == 1) {
                this.ports[0] = this.ports[1] = Integer.parseInt(portStrings[0]);
                return;
            } else {
                if (portStrings.length != 2) throw new IllegalArgumentException(String.format("Cannot have more than two port ranges: %s", hostnamePort));
                this.ports[0] = Integer.parseInt(portStrings[0]);
                this.ports[1] = Integer.parseInt(portStrings[1]);
            }
        }
    }

    private String zeroLengthMeansNull(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public HostnamePort(String host, int port) {
        this(host, port, port);
    }

    public HostnamePort(String host, int portFrom, int portTo) {
        this.host = host;
        this.ports = new int[]{portFrom, portTo};
    }

    public String getHost() {
        return this.host;
    }

    public String getHost(String defaultHost) {
        return this.host == null ? defaultHost : this.host;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public int getPort() {
        return this.ports[0];
    }

    public boolean isRange() {
        return this.ports[0] != this.ports[1];
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String defaultHost) {
        StringBuilder builder = new StringBuilder();
        String host = this.getHost(defaultHost);
        if (host != null) {
            builder.append(host);
        }
        if (this.getPort() != 0) {
            builder.append(":");
            builder.append(this.getPort());
            if (this.isRange()) {
                builder.append("-").append(this.getPorts()[1]);
            }
        }
        return builder.toString();
    }

    public boolean matches(URI toMatch) {
        boolean result = false;
        for (int port = this.ports[0]; port <= this.ports[1]; ++port) {
            if (port != toMatch.getPort()) continue;
            result = true;
            break;
        }
        if (this.host == null && toMatch.getHost() == null) {
            return result;
        }
        if (this.host == null) {
            return false;
        }
        return result && this.host.equalsIgnoreCase(toMatch.getHost());
    }
}

