/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.SideSelectorPolicy;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.kernel.SideSelectorPolicies;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.BidirectionalTraverserImpl;
import org.neo4j.kernel.impl.traversal.BranchCollisionPolicies;
import org.neo4j.kernel.impl.traversal.BranchCollisionPolicy;
import org.neo4j.kernel.impl.traversal.TraversalDescriptionImpl;

public class BidirectionalTraversalDescriptionImpl
implements BidirectionalTraversalDescription {
    final TraversalDescription start;
    final TraversalDescription end;
    final PathEvaluator collisionEvaluator;
    final SideSelectorPolicy sideSelector;
    final BranchCollisionPolicy collisionPolicy;
    final int maxDepth;

    private BidirectionalTraversalDescriptionImpl(TraversalDescription start, TraversalDescription end, BranchCollisionPolicy collisionPolicy, PathEvaluator collisionEvaluator, SideSelectorPolicy sideSelector, int maxDepth) {
        this.start = start;
        this.end = end;
        this.collisionPolicy = collisionPolicy;
        this.collisionEvaluator = collisionEvaluator;
        this.sideSelector = sideSelector;
        this.maxDepth = maxDepth;
    }

    public BidirectionalTraversalDescriptionImpl() {
        this(Traversal.traversal(), Traversal.traversal(), BranchCollisionPolicies.STANDARD, Evaluators.all(), SideSelectorPolicies.ALTERNATING, Integer.MAX_VALUE);
    }

    @Override
    public BidirectionalTraversalDescription startSide(TraversalDescription startSideDescription) {
        return new BidirectionalTraversalDescriptionImpl(startSideDescription, this.end, this.collisionPolicy, this.collisionEvaluator, this.sideSelector, this.maxDepth);
    }

    @Override
    public BidirectionalTraversalDescription endSide(TraversalDescription endSideDescription) {
        return new BidirectionalTraversalDescriptionImpl(this.start, endSideDescription, this.collisionPolicy, this.collisionEvaluator, this.sideSelector, this.maxDepth);
    }

    @Override
    public BidirectionalTraversalDescription mirroredSides(TraversalDescription sideDescription) {
        return new BidirectionalTraversalDescriptionImpl(sideDescription, sideDescription.reverse(), this.collisionPolicy, this.collisionEvaluator, this.sideSelector, this.maxDepth);
    }

    @Override
    public BidirectionalTraversalDescription collisionPolicy(BranchCollisionPolicy collisionPolicy) {
        return new BidirectionalTraversalDescriptionImpl(this.start, this.end, collisionPolicy, this.collisionEvaluator, this.sideSelector, this.maxDepth);
    }

    @Override
    public BidirectionalTraversalDescription collisionEvaluator(PathEvaluator collisionEvaluator) {
        TraversalDescriptionImpl.nullCheck(collisionEvaluator, Evaluator.class, "RETURN_ALL");
        return new BidirectionalTraversalDescriptionImpl(this.start, this.end, this.collisionPolicy, TraversalDescriptionImpl.addEvaluator(this.collisionEvaluator, collisionEvaluator), this.sideSelector, this.maxDepth);
    }

    @Override
    public BidirectionalTraversalDescription collisionEvaluator(Evaluator collisionEvaluator) {
        return this.collisionEvaluator(new Evaluator.AsPathEvaluator(collisionEvaluator));
    }

    @Override
    public BidirectionalTraversalDescription sideSelector(SideSelectorPolicy sideSelector, int maxDepth) {
        return new BidirectionalTraversalDescriptionImpl(this.start, this.end, this.collisionPolicy, this.collisionEvaluator, sideSelector, maxDepth);
    }

    @Override
    public Traverser traverse(Node start, Node end) {
        return new BidirectionalTraverserImpl(this, Arrays.asList(start), Arrays.asList(end));
    }

    @Override
    public Traverser traverse(Iterable<Node> start, Iterable<Node> end) {
        return new BidirectionalTraverserImpl(this, start, end);
    }
}

