/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.ReadOnlyTransactionImpl;
import org.neo4j.kernel.impl.transaction.TransactionImpl;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaResource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.ThreadLocalWithSize;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class ReadOnlyTxManager
extends AbstractTransactionManager
implements Lifecycle {
    private ThreadLocalWithSize<ReadOnlyTransactionImpl> txThreadMap;
    private int eventIdentifierCounter = 0;
    private XaDataSourceManager xaDsManager = null;
    private final StringLogger logger;

    public ReadOnlyTxManager(XaDataSourceManager xaDsManagerToUse, StringLogger logger) {
        this.xaDsManager = xaDsManagerToUse;
        this.logger = logger;
    }

    synchronized int getNextEventIdentifier() {
        return this.eventIdentifierCounter++;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() throws Throwable {
        this.txThreadMap = new ThreadLocalWithSize();
    }

    @Override
    public void stop() {
    }

    @Override
    public void shutdown() throws Throwable {
    }

    public void begin() throws NotSupportedException {
        if (this.txThreadMap.get() != null) {
            throw new NotSupportedException("Nested transactions not supported");
        }
        this.txThreadMap.set(new ReadOnlyTransactionImpl(this, this.logger));
    }

    public void commit() throws RollbackException, HeuristicMixedException, IllegalStateException {
        ReadOnlyTransactionImpl tx = (ReadOnlyTransactionImpl)this.txThreadMap.get();
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        if (tx.getStatus() != 0 && tx.getStatus() != 1) {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
        tx.doBeforeCompletion();
        if (tx.getStatus() == 0) {
            this.commit(tx);
        } else if (tx.getStatus() == 1) {
            this.rollbackCommit(tx);
        } else {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
    }

    private void commit(ReadOnlyTransactionImpl tx) {
        if (tx.getResourceCount() != 0) {
            throw new ReadOnlyDbException();
        }
        tx.setStatus(3);
        tx.doAfterCompletion();
        this.txThreadMap.remove();
        tx.setStatus(6);
    }

    private void rollbackCommit(ReadOnlyTransactionImpl tx) throws HeuristicMixedException, RollbackException {
        try {
            tx.doRollback();
        }
        catch (XAException e) {
            this.logger.error("Unable to rollback marked transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
            throw Exceptions.withCause(new HeuristicMixedException("Unable to rollback  ---> error code for rollback: " + e.errorCode), e);
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove();
        tx.setStatus(6);
        throw new RollbackException("Failed to commit, transaction rolledback");
    }

    public void rollback() throws IllegalStateException, SystemException {
        ReadOnlyTransactionImpl tx = (ReadOnlyTransactionImpl)this.txThreadMap.get();
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        if (tx.getStatus() == 0 || tx.getStatus() == 1 || tx.getStatus() == 7) {
            tx.doBeforeCompletion();
            try {
                tx.doRollback();
            }
            catch (XAException e) {
                this.logger.error("Unable to rollback marked or active transaction. Some resources may be commited others not. Neo4j kernel should be SHUTDOWN for resource maintance and transaction recovery ---->", e);
                throw Exceptions.withCause(new SystemException("Unable to rollback  ---> error code for rollback: " + e.errorCode), e);
            }
        } else {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove();
        tx.setStatus(6);
    }

    public int getStatus() {
        ReadOnlyTransactionImpl tx = (ReadOnlyTransactionImpl)this.txThreadMap.get();
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() {
        return (Transaction)this.txThreadMap.get();
    }

    public void resume(Transaction tx) throws IllegalStateException {
        ReadOnlyTransactionImpl txImpl;
        if (this.txThreadMap.get() != null) {
            throw new IllegalStateException("Transaction already associated");
        }
        if (tx != null && (txImpl = (ReadOnlyTransactionImpl)tx).getStatus() != 6) {
            txImpl.markAsActive();
            this.txThreadMap.set(txImpl);
        }
    }

    public Transaction suspend() {
        ReadOnlyTransactionImpl tx = (ReadOnlyTransactionImpl)this.txThreadMap.get();
        this.txThreadMap.remove();
        if (tx != null) {
            tx.markAsSuspended();
        }
        return tx;
    }

    public void setRollbackOnly() throws IllegalStateException {
        ReadOnlyTransactionImpl tx = (ReadOnlyTransactionImpl)this.txThreadMap.get();
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) {
    }

    byte[] getBranchId(XAResource xaRes) {
        byte[] branchId;
        if (xaRes instanceof XaResource && (branchId = ((XaResource)xaRes).getBranchId()) != null) {
            return branchId;
        }
        return this.xaDsManager.getBranchId(xaRes);
    }

    String getTxStatusAsString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    public synchronized void dumpTransactions() {
    }

    @Override
    public int getEventIdentifier() {
        TransactionImpl tx = (TransactionImpl)this.getTransaction();
        if (tx != null) {
            return tx.getEventIdentifier();
        }
        return -1;
    }

    @Override
    public void doRecovery() throws Throwable {
    }

    @Override
    public TransactionState getTransactionState() {
        return TransactionState.NO_STATE;
    }
}

