/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class NodeStore
extends AbstractStore
implements Store,
RecordStore<NodeRecord> {
    public static final String TYPE_DESCRIPTOR = "NodeStore";
    public static final int RECORD_SIZE = 9;

    public NodeStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, config, IdType.NODE, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
    }

    @Override
    public void accept(RecordStore.Processor processor, NodeRecord record) {
        processor.processNode(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRecord getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            NodeRecord nodeRecord = this.getRecord(id, window, RecordLoad.NORMAL);
            return nodeRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRecord forceGetRecord(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return new NodeRecord(id, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        try {
            NodeRecord nodeRecord = this.getRecord(id, window, RecordLoad.FORCE);
            return nodeRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public NodeRecord forceGetRaw(NodeRecord record) {
        return record;
    }

    @Override
    public NodeRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(NodeRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateRecord(NodeRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window, true);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(NodeRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window, false);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRecord loadLightNode(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return null;
        }
        try {
            NodeRecord nodeRecord = this.getRecord(id, window, RecordLoad.CHECK);
            return nodeRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private NodeRecord getRecord(long id, PersistenceWindow window, RecordLoad load) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (!inUse) {
            switch (load) {
                case NORMAL: {
                    throw new InvalidRecordException("NodeRecord[" + id + "] not in use");
                }
                case CHECK: {
                    return null;
                }
            }
        }
        long nextRel = buffer.getUnsignedInt();
        long nextProp = buffer.getUnsignedInt();
        long relModifier = (inUseByte & 0xEL) << 31;
        long propModifier = (inUseByte & 0xF0L) << 28;
        NodeRecord nodeRecord = new NodeRecord(id, this.longFromIntAndMod(nextRel, relModifier), this.longFromIntAndMod(nextProp, propModifier));
        nodeRecord.setInUse(inUse);
        return nodeRecord;
    }

    private void updateRecord(NodeRecord record, PersistenceWindow window, boolean force) {
        long id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse() || force) {
            long nextRel = record.getNextRel();
            long nextProp = record.getNextProp();
            short relModifier = nextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((nextRel & 0x700000000L) >> 31);
            int propModifier = (short)(nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0 : (short)((nextProp & 0xF00000000L) >> 28));
            short inUseUnsignedByte = (record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue();
            inUseUnsignedByte = (short)(inUseUnsignedByte | relModifier | propModifier);
            buffer.put((byte)inUseUnsignedByte).putInt((int)nextRel).putInt((int)nextProp);
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.getWindowPoolStats());
        return list;
    }

    public static abstract class Configuration
    extends AbstractStore.Configuration {
    }
}

