/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.util.ArrayMap;

class PropertyIndexHolder {
    private final ArrayMap<String, Integer> propertyIndexes = new ArrayMap(5, false, false);
    private final ArrayMap<Integer, String> idToIndex = new ArrayMap(5, false, false);

    PropertyIndexHolder(NameData[] indexes) {
        for (NameData index : indexes) {
            this.propertyIndexes.put(index.getName(), index.getId());
            this.idToIndex.put(index.getId(), index.getName());
        }
    }

    void addPropertyIndex(String stringKey, int keyId) {
        this.propertyIndexes.put(stringKey, keyId);
        this.idToIndex.put(keyId, stringKey);
    }

    int getKeyId(String stringKey) {
        Integer keyId = this.propertyIndexes.get(stringKey);
        if (keyId != null) {
            return keyId;
        }
        return -1;
    }

    String getStringKey(int keyId) {
        String stringKey = this.idToIndex.get(keyId);
        if (stringKey == null) {
            throw new NotFoundException("No such property index[" + keyId + "]");
        }
        return stringKey;
    }
}

