/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.util.StringLogger;

public class LegacyNeoStoreReader {
    private static final int RECORD_LENGTH = 9;
    private FileChannel fileChannel;
    private PersistenceWindowPool windowPool;

    public LegacyNeoStoreReader(File fileName, StringLogger log) throws FileNotFoundException {
        this.fileChannel = new RandomAccessFile(fileName, "r").getChannel();
        this.windowPool = new PersistenceWindowPool(fileName, 9, this.fileChannel, 0L, true, true, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRecord(long id) {
        PersistenceWindow window = this.windowPool.acquire(id, OperationType.READ);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.get();
            long l = buffer.getLong();
            return l;
        }
        finally {
            this.windowPool.release(window);
        }
    }

    public long getCreationTime() {
        return this.getRecord(0L);
    }

    public long getRandomNumber() {
        return this.getRecord(1L);
    }

    public long getVersion() {
        return this.getRecord(2L);
    }

    public long getLastCommittedTx() {
        return this.getRecord(3L);
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }
}

