/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.BranchCollisionDetector;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.kernel.BidirectionalTraversalBranchPath;

public class StandardBranchCollisionDetector
implements BranchCollisionDetector {
    private final Map<Node, Collection<TraversalBranch>[]> paths = new HashMap<Node, Collection<TraversalBranch>[]>(1000);
    private final Evaluator evaluator;
    private final Set<Path> returnedPaths = new HashSet<Path>();

    public StandardBranchCollisionDetector(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public Collection<Path> evaluate(TraversalBranch branch, Direction direction) {
        Collection<TraversalBranch>[] pathsHere = this.paths.get(branch.endNode());
        int index = direction.ordinal();
        if (pathsHere == null) {
            pathsHere = new Collection[]{new ArrayList(), new ArrayList()};
            this.paths.put(branch.endNode(), pathsHere);
        }
        pathsHere[index].add(branch);
        Collection<TraversalBranch> otherCollections = pathsHere[index == 0 ? 1 : 0];
        if (!otherCollections.isEmpty()) {
            ArrayList<Path> foundPaths = new ArrayList<Path>();
            for (TraversalBranch otherBranch : otherCollections) {
                TraversalBranch endPath;
                TraversalBranch startPath = index == 0 ? branch : otherBranch;
                BidirectionalTraversalBranchPath path = new BidirectionalTraversalBranchPath(startPath, endPath = index == 0 ? otherBranch : branch);
                if (!this.returnedPaths.add(path) || !this.includePath(path, startPath, endPath)) continue;
                foundPaths.add(path);
            }
            if (!foundPaths.isEmpty()) {
                return foundPaths;
            }
        }
        return null;
    }

    protected boolean includePath(Path path, TraversalBranch startPath, TraversalBranch endPath) {
        Evaluation eval = this.evaluator.evaluate(path);
        if (!eval.continues()) {
            startPath.evaluation(eval);
            endPath.evaluation(eval);
        }
        return eval.includes();
    }
}

