/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.FileUtils;

public class DefaultFileSystemAbstraction
implements FileSystemAbstraction {
    @Override
    public FileChannel open(File fileName, String mode) throws IOException {
        return new RandomAccessFile(fileName, mode).getChannel();
    }

    @Override
    public FileLock tryLock(File fileName, FileChannel channel) throws IOException {
        return FileLock.getOsSpecificFileLock(fileName, channel);
    }

    @Override
    public FileChannel create(File fileName) throws IOException {
        return this.open(fileName, "rw");
    }

    @Override
    public boolean fileExists(File fileName) {
        return fileName.exists();
    }

    @Override
    public long getFileSize(File fileName) {
        return fileName.length();
    }

    @Override
    public boolean deleteFile(File fileName) {
        return FileUtils.deleteFile(fileName);
    }

    @Override
    public boolean renameFile(File from, File to) throws IOException {
        return FileUtils.renameFile(from, to);
    }

    @Override
    public void copyFile(File fromFile, File toFile) throws IOException {
        if (fromFile.isDirectory()) {
            FileUtils.copyRecursively(fromFile, toFile);
        } else {
            FileUtils.copyFile(fromFile, toFile);
        }
    }

    @Override
    public void autoCreatePath(File path) throws IOException {
        if (!path.isDirectory()) {
            path = path.getParentFile();
        }
        if (!path.exists() && !path.mkdirs()) {
            throw new IOException("Unable to create directory path[" + path + "] for Neo4j store.");
        }
    }
}

