/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.lang.reflect.InvocationTargetException;
import org.neo4j.helpers.Predicate;

public class Exceptions {
    private static final String UNEXPECTED_MESSAGE = "Unexpected Exception";

    public static <T extends Throwable> T withCause(T exception, Throwable cause) {
        try {
            exception.initCause(cause);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return exception;
    }

    public static RuntimeException launderedException(Throwable exception) {
        return Exceptions.launderedException(UNEXPECTED_MESSAGE, exception);
    }

    public static RuntimeException launderedException(String messageForUnexpected, Throwable exception) {
        return Exceptions.launderedException(RuntimeException.class, messageForUnexpected, exception);
    }

    public static <T extends Throwable> T launderedException(Class<T> type, Throwable exception) {
        return Exceptions.launderedException(type, UNEXPECTED_MESSAGE, exception);
    }

    public static <T extends Throwable> T launderedException(Class<T> type, String messageForUnexpected, Throwable exception) {
        if (type.isInstance(exception)) {
            return (T)((Throwable)type.cast(exception));
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception instanceof InvocationTargetException) {
            return Exceptions.launderedException(type, messageForUnexpected, ((InvocationTargetException)exception).getTargetException());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(messageForUnexpected, exception);
    }

    public static Throwable peel(Throwable exception, Predicate<Throwable> toPeel) {
        while (exception != null && toPeel.accept(exception)) {
            exception = exception.getCause();
        }
        return exception;
    }

    public static Predicate<Throwable> exceptionsOfType(final Class<? extends Throwable> ... types) {
        return new Predicate<Throwable>(){

            @Override
            public boolean accept(Throwable item) {
                for (Class type : types) {
                    if (!type.isAssignableFrom(item.getClass())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private Exceptions() {
    }
}

