/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class TransactionInterceptorProviders {
    private final Iterable<TransactionInterceptorProvider> providers;
    private final DependencyResolver resolver;
    private final Config config;

    public TransactionInterceptorProviders(Iterable<TransactionInterceptorProvider> providers, DependencyResolver resolver) {
        this.providers = providers;
        this.resolver = resolver;
        this.config = resolver.resolveDependency(Config.class);
    }

    public TransactionInterceptor resolveChain(XaDataSource ds) {
        TransactionInterceptor first = null;
        for (TransactionInterceptorProvider provider : this.providers) {
            String prov = this.getConfigForInterceptor(provider);
            if (first == null) {
                first = provider.create(ds, prov, this.resolver);
                continue;
            }
            TransactionInterceptor temp = provider.create(first, ds, prov, this.resolver);
            if (temp == null) continue;
            first = temp;
        }
        return first;
    }

    public boolean shouldInterceptCommitting() {
        return this.config.get(GraphDatabaseSettings.intercept_committing_transactions) != false && this.providers.iterator().hasNext();
    }

    public boolean shouldInterceptDeserialized() {
        return this.config.get(GraphDatabaseSettings.intercept_deserialized_transactions) != false && this.providers.iterator().hasNext();
    }

    public boolean hasAnyInterceptorConfigured() {
        for (TransactionInterceptorProvider provider : this.providers) {
            if (this.getConfigForInterceptor(provider) == null) continue;
            return true;
        }
        return false;
    }

    private String getConfigForInterceptor(TransactionInterceptorProvider provider) {
        String prov = this.config.getParams().get(TransactionInterceptorProvider.class.getSimpleName() + "." + provider.name());
        return prov;
    }
}

