/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class Listeners {
    public static <T> Iterable<T> newListeners() {
        return new LinkedList();
    }

    public static <T> Iterable<T> addListener(T listener, Iterable<T> listeners) {
        LinkedList<T> newListeners = new LinkedList<T>((Collection)listeners);
        newListeners.add(listener);
        return newListeners;
    }

    public static <T> Iterable<T> removeListener(T listener, Iterable<T> listeners) {
        LinkedList newListeners = new LinkedList((Collection)listeners);
        newListeners.remove(listener);
        return newListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void notifyListeners(Iterable<T> listeners, Notification<T> notification) {
        Iterator<T> i$ = listeners.iterator();
        while (i$.hasNext()) {
            T listener;
            T t = listener = i$.next();
            synchronized (t) {
                try {
                    notification.notify(listener);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static <T> void notifyListeners(Iterable<T> listeners, Executor executor, final Notification<T> notification) {
        for (final T listener : listeners) {
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = listener;
                    synchronized (object) {
                        try {
                            notification.notify(listener);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    public static interface Notification<T> {
        public void notify(T var1);
    }
}

