/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.Transaction;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.transaction.LockManager;

public enum LockType {
    READ{

        @Override
        public void acquire(Object resource, LockManager lockManager, Transaction tx) {
            lockManager.getReadLock(resource, tx);
        }

        @Override
        public void unacquire(Object resource, LockManager lockManager, TransactionState state, Transaction tx) {
            lockManager.releaseReadLock(resource, tx);
        }

        @Override
        public void release(Object resource, LockManager lockManager, Transaction tx) {
            lockManager.releaseReadLock(resource, tx);
        }
    }
    ,
    WRITE{

        @Override
        public void acquire(Object resource, LockManager lockManager, Transaction tx) {
            lockManager.getWriteLock(resource, tx);
        }

        @Override
        public void unacquire(Object resource, LockManager lockManager, TransactionState state, Transaction tx) {
            state.addLockToTransaction(lockManager, resource, this);
        }

        @Override
        public void release(Object resource, LockManager lockManager, Transaction tx) {
            lockManager.releaseWriteLock(resource, tx);
        }
    };


    public abstract void acquire(Object var1, LockManager var2, Transaction var3);

    public abstract void unacquire(Object var1, LockManager var2, TransactionState var3, Transaction var4);

    public abstract void release(Object var1, LockManager var2, Transaction var3);

    public void acquire(Object resource, LockManager lockManager) {
        this.acquire(resource, lockManager, null);
    }

    public void unacquire(Object resource, LockManager lockManager, TransactionState state) {
        this.unacquire(resource, lockManager, state, null);
    }

    public void release(Object resource, LockManager lockManager) {
        this.release(resource, lockManager, null);
    }
}

