/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.TransactionManager;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.TopLevelTransaction;

public class PlaceboTransaction
implements Transaction {
    public static final Lock NO_LOCK = new Lock(){

        @Override
        public void release() {
        }
    };
    private final TransactionManager transactionManager;
    private final TopLevelTransaction.TransactionOutcome outcome = new TopLevelTransaction.TransactionOutcome();

    public PlaceboTransaction(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void failure() {
        this.outcome.failed();
    }

    @Override
    public void success() {
        this.outcome.success();
    }

    @Override
    public void finish() {
        if (!this.outcome.canCommit()) {
            this.markAsRollback();
        }
    }

    private void markAsRollback() {
        try {
            this.transactionManager.getTransaction().setRollbackOnly();
        }
        catch (Exception e) {
            throw new TransactionFailureException("Failed to mark transaction as rollback only.", e);
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        return NO_LOCK;
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        return NO_LOCK;
    }
}

