/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultipleCauseException
extends Exception {
    private static final long serialVersionUID = -5556701516106141749L;
    private static final String ALSO_CAUSED_BY = "Also caused by: ";
    private final List<Throwable> causes = new ArrayList<Throwable>();

    public MultipleCauseException(String message, List<Throwable> causes) {
        super(message, causes.get(0));
        for (Throwable cause : causes) {
            this.addCause(cause);
        }
    }

    public MultipleCauseException(String message, Throwable firstCause) {
        super(message, firstCause);
        this.causes.add(firstCause);
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    public void addCause(Throwable cause) {
        this.causes.add(cause);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        this.printAllButFirstCauseStackTrace(out);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        this.printAllButFirstCauseStackTrace(out);
    }

    private void printAllButFirstCauseStackTrace(PrintStream out) {
        Iterator<Throwable> causeIterator = this.causes.iterator();
        if (causeIterator.hasNext()) {
            causeIterator.next();
            while (causeIterator.hasNext()) {
                out.print(ALSO_CAUSED_BY);
                causeIterator.next().printStackTrace(out);
            }
        }
    }

    private void printAllButFirstCauseStackTrace(PrintWriter out) {
        Iterator<Throwable> causeIterator = this.causes.iterator();
        if (causeIterator.hasNext()) {
            causeIterator.next();
            while (causeIterator.hasNext()) {
                out.print(ALSO_CAUSED_BY);
                causeIterator.next().printStackTrace(out);
            }
        }
    }
}

