/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.util.StringLogger;

public class StoreFactory {
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final WindowPoolFactory windowPoolFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final StringLogger stringLogger;
    private final RemoteTxHook txHook;

    public StoreFactory(Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, RemoteTxHook txHook) {
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.windowPoolFactory = windowPoolFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.stringLogger = stringLogger;
        this.txHook = txHook;
    }

    public boolean ensureStoreExists() throws IOException {
        boolean readOnly = this.config.get(GraphDatabaseSettings.read_only);
        File store = this.config.get(GraphDatabaseSettings.neo_store);
        boolean created = false;
        if (!readOnly && !this.fileSystemAbstraction.fileExists(store)) {
            this.stringLogger.logMessage("Creating new db @ " + store, true);
            this.fileSystemAbstraction.mkdirs(store.getParentFile());
            this.createNeoStore(store).close();
            created = true;
        }
        return created;
    }

    public NeoStore newNeoStore(File fileName) {
        try {
            return this.attemptNewNeoStore(fileName);
        }
        catch (NotCurrentStoreVersionException e) {
            this.tryToUpgradeStores(fileName);
            return this.attemptNewNeoStore(fileName);
        }
    }

    NeoStore attemptNewNeoStore(File fileName) {
        return new NeoStore(fileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, this.txHook, this.newRelationshipTypeStore(new File(fileName.getPath() + ".relationshiptypestore.db")), this.newPropertyStore(new File(fileName.getPath() + ".propertystore.db")), this.newRelationshipStore(new File(fileName.getPath() + ".relationshipstore.db")), this.newNodeStore(new File(fileName.getPath() + ".nodestore.db")));
    }

    private void tryToUpgradeStores(File fileName) {
        new StoreUpgrader(this.config, this.stringLogger, new ConfigMapUpgradeConfiguration(this.config), new UpgradableDatabase(new StoreVersionCheck(this.fileSystemAbstraction)), new StoreMigrator(new VisibleMigrationProgressMonitor(this.stringLogger, System.out)), new DatabaseFiles(this.fileSystemAbstraction), this.idGeneratorFactory, this.fileSystemAbstraction).attemptUpgrade(fileName);
    }

    private DynamicStringStore newDynamicStringStore(File fileName, IdType nameIdType) {
        return new DynamicStringStore(fileName, this.config, nameIdType, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    RelationshipTypeStore newRelationshipTypeStore(File baseFileName) {
        DynamicStringStore nameStore = this.newDynamicStringStore(new File(baseFileName.getPath() + ".names"), IdType.RELATIONSHIP_TYPE_BLOCK);
        return new RelationshipTypeStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, nameStore);
    }

    PropertyStore newPropertyStore(File baseFileName) {
        DynamicStringStore stringPropertyStore = this.newDynamicStringStore(new File(baseFileName.getPath() + ".strings"), IdType.STRING_BLOCK);
        PropertyIndexStore propertyIndexStore = this.newPropertyIndexStore(new File(baseFileName.getPath() + ".index"));
        DynamicArrayStore arrayPropertyStore = this.newDynamicArrayStore(new File(baseFileName.getPath() + ".arrays"));
        return new PropertyStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, stringPropertyStore, propertyIndexStore, arrayPropertyStore);
    }

    PropertyIndexStore newPropertyIndexStore(File baseFileName) {
        DynamicStringStore nameStore = this.newDynamicStringStore(new File(baseFileName.getPath() + ".keys"), IdType.PROPERTY_INDEX_BLOCK);
        return new PropertyIndexStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger, nameStore);
    }

    public RelationshipStore newRelationshipStore(File baseFileName) {
        return new RelationshipStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    private DynamicArrayStore newDynamicArrayStore(File baseFileName) {
        return new DynamicArrayStore(baseFileName, this.config, IdType.ARRAY_BLOCK, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    NodeStore newNodeStore(File baseFileName) {
        return new NodeStore(baseFileName, this.config, this.idGeneratorFactory, this.windowPoolFactory, this.fileSystemAbstraction, this.stringLogger);
    }

    public NeoStore createNeoStore(File fileName) {
        return this.createNeoStore(fileName, new StoreId());
    }

    public NeoStore createNeoStore(File fileName, StoreId storeId) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("NeoStore"));
        this.createNodeStore(new File(fileName.getPath() + ".nodestore.db"));
        this.createRelationshipStore(new File(fileName.getPath() + ".relationshipstore.db"));
        this.createPropertyStore(new File(fileName.getPath() + ".propertystore.db"));
        this.createRelationshipTypeStore(new File(fileName.getPath() + ".relationshiptypestore.db"));
        NeoStore neoStore = this.newNeoStore(fileName);
        for (int i = 0; i < 6; ++i) {
            neoStore.nextId();
        }
        neoStore.setCreationTime(storeId.getCreationTime());
        neoStore.setRandomNumber(storeId.getRandomId());
        neoStore.setVersion(0L);
        neoStore.setLastCommittedTx(1L);
        neoStore.setStoreVersion(storeId.getStoreVersion());
        neoStore.setGraphNextProp(-1L);
        return neoStore;
    }

    private void createNodeStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("NodeStore"));
        NodeStore store = this.newNodeStore(fileName);
        NodeRecord nodeRecord = new NodeRecord(store.nextId(), Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        nodeRecord.setInUse(true);
        store.updateRecord(nodeRecord);
        store.close();
    }

    private void createRelationshipStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("RelationshipStore"));
    }

    private void createPropertyStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("PropertyStore"));
        int stringStoreBlockSize = this.config.get(Configuration.string_block_size);
        int arrayStoreBlockSize = this.config.get(Configuration.array_block_size);
        this.createDynamicStringStore(new File(fileName.getPath() + ".strings"), stringStoreBlockSize, IdType.STRING_BLOCK);
        this.createPropertyIndexStore(new File(fileName.getPath() + ".index"));
        this.createDynamicArrayStore(new File(fileName.getPath() + ".arrays"), arrayStoreBlockSize);
    }

    private void createRelationshipTypeStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("RelationshipTypeStore"));
        this.createDynamicStringStore(new File(fileName.getPath() + ".names"), 30, IdType.RELATIONSHIP_TYPE_BLOCK);
        RelationshipTypeStore store = this.newRelationshipTypeStore(fileName);
        store.close();
    }

    private void createDynamicStringStore(File fileName, int blockSize, IdType idType) {
        this.createEmptyDynamicStore(fileName, blockSize, "StringPropertyStore v0.A.0", idType);
    }

    private void createPropertyIndexStore(File fileName) {
        this.createEmptyStore(fileName, this.buildTypeDescriptorAndVersion("PropertyIndexStore"));
        this.createDynamicStringStore(new File(fileName.getPath() + ".keys"), 30, IdType.PROPERTY_INDEX_BLOCK);
    }

    public void createDynamicArrayStore(File fileName, int blockSize) {
        this.createEmptyDynamicStore(fileName, blockSize, "ArrayPropertyStore v0.A.0", IdType.ARRAY_BLOCK);
    }

    public void createEmptyDynamicStore(File fileName, int baseBlockSize, String typeAndVersionDescriptor, IdType idType) {
        int blockSize = baseBlockSize;
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (this.fileSystemAbstraction.fileExists(fileName)) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "]");
        }
        if (blockSize > 65535) {
            throw new IllegalArgumentException("Illegal block size[" + blockSize + "], limit is 65535");
        }
        blockSize += 8;
        try {
            StoreChannel channel = this.fileSystemAbstraction.create(fileName);
            int endHeaderSize = blockSize + UTF8.encode(typeAndVersionDescriptor).length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.putInt(blockSize);
            buffer.position(endHeaderSize - typeAndVersionDescriptor.length());
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        this.idGeneratorFactory.create(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), 0L);
        IdGenerator idGenerator = this.idGeneratorFactory.open(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), idType.getGrabSize(), idType, 0L);
        idGenerator.nextId();
        idGenerator.close();
    }

    public void createEmptyStore(File fileName, String typeAndVersionDescriptor) {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (this.fileSystemAbstraction.fileExists(fileName)) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        try {
            StoreChannel channel = this.fileSystemAbstraction.create(fileName);
            int endHeaderSize = UTF8.encode(typeAndVersionDescriptor).length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        this.idGeneratorFactory.create(this.fileSystemAbstraction, new File(fileName.getPath() + ".id"), 0L);
    }

    public String buildTypeDescriptorAndVersion(String typeDescriptor) {
        return typeDescriptor + " " + "v0.A.0";
    }

    public static abstract class Configuration {
        public static final GraphDatabaseSetting.IntegerSetting string_block_size = GraphDatabaseSettings.string_block_size;
        public static final GraphDatabaseSetting.IntegerSetting array_block_size = GraphDatabaseSettings.array_block_size;
    }
}

