/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class RelationshipTypeStore
extends AbstractNameStore<RelationshipTypeRecord> {
    public static final String TYPE_DESCRIPTOR = "RelationshipTypeStore";
    private static final int RECORD_SIZE = 5;

    public RelationshipTypeStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore) {
        super(fileName, config, IdType.RELATIONSHIP_TYPE, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger, nameStore);
    }

    @Override
    public void accept(RecordStore.Processor processor, RelationshipTypeRecord record) {
        processor.processRelationshipType(this, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsReserved(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.WRITE);
        try {
            this.markAsReserved(id, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private void markAsReserved(int id, PersistenceWindow window) {
        Buffer buffer = window.getOffsettedBuffer(id);
        buffer.put(Record.IN_USE.byteValue()).putInt(Record.RESERVED.intValue());
    }

    @Override
    protected RelationshipTypeRecord newRecord(int id) {
        return new RelationshipTypeRecord(id);
    }

    @Override
    public int getRecordSize() {
        return 5;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected boolean reserveIdsDuringRebuild() {
        return true;
    }

    public static abstract class Configuration
    extends AbstractNameStore.Configuration {
    }
}

