/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;

public class NoCache<E extends EntityWithSizeObject>
implements Cache<E> {
    private final String name;
    private volatile long misses;
    private static final AtomicLong MISSES = new AtomicLong(0L);

    public NoCache(String name) {
        this.name = name;
    }

    @Override
    public E put(E value) {
        return value;
    }

    @Override
    public void putAll(Collection<E> values) {
    }

    @Override
    public E get(long key) {
        MISSES.incrementAndGet();
        return null;
    }

    @Override
    public E remove(long key) {
        return null;
    }

    @Override
    public long hitCount() {
        return 0L;
    }

    @Override
    public long missCount() {
        return this.misses;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public void clear() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void updateSize(E entity, int newSize) {
    }

    @Override
    public void printStatistics() {
    }
}

