/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockNotFoundException;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.LockInfo;
import org.neo4j.kernel.info.LockingTransaction;
import org.neo4j.kernel.info.ResourceType;
import org.neo4j.kernel.info.WaitingThread;

class RWLock
implements Visitor<StringLogger.LineLogger> {
    private final Object resource;
    private final LinkedList<WaitElement> waitingThreadList = new LinkedList();
    private final ArrayMap<Transaction, TxLockElement> txLockElementMap = new ArrayMap(5, false, true);
    private final RagManager ragManager;
    private int totalReadCount;
    private int totalWriteCount;
    private int marked;

    RWLock(Object resource, RagManager ragManager) {
        this.resource = resource;
        this.ragManager = ragManager;
    }

    synchronized void mark() {
        ++this.marked;
    }

    synchronized boolean isMarked() {
        return this.marked > 0;
    }

    void acquireReadLock() throws DeadlockDetectedException {
        this.acquireReadLock(this.ragManager.getCurrentTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireReadLock(Transaction tx) throws DeadlockDetectedException {
        tx = this.getCurrentTransaction(tx);
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            tle.movedOn = false;
            while (this.totalWriteCount > tle.writeCount) {
                this.deadlockGuardedWait(tx, tle, LockType.READ);
            }
            this.registerReadLockAcquired(tx, tle);
        }
        finally {
            tle.movedOn = true;
            --this.marked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean tryAcquireReadLock(Transaction tx) {
        tx = this.getCurrentTransaction(tx);
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            tle.movedOn = false;
            if (this.totalWriteCount > tle.writeCount) {
                boolean bl = false;
                return bl;
            }
            this.registerReadLockAcquired(tx, tle);
            boolean bl = true;
            return bl;
        }
        finally {
            tle.movedOn = true;
            --this.marked;
        }
    }

    synchronized void releaseReadLock(Transaction tx) throws LockNotFoundException {
        TxLockElement tle = this.getLockElement(tx = this.getCurrentTransaction(tx));
        if (tle.readCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have readLock");
        }
        --this.totalReadCount;
        tle.readCount--;
        if (tle.isFree()) {
            this.txLockElementMap.remove(tx);
            this.ragManager.lockReleased(this, tx);
        }
        if (this.waitingThreadList.size() > 0) {
            WaitElement we = this.waitingThreadList.getLast();
            if (we.lockType == LockType.WRITE) {
                if (this.totalReadCount == we.element.readCount) {
                    this.waitingThreadList.removeLast();
                    if (!we.element.movedOn) {
                        we.waitingThread.interrupt();
                    }
                } else {
                    ListIterator<WaitElement> listItr = this.waitingThreadList.listIterator(this.waitingThreadList.lastIndexOf(we));
                    while (listItr.hasPrevious()) {
                        we = listItr.previous();
                        if (we.lockType == LockType.WRITE && this.totalReadCount == we.element.readCount) {
                            listItr.remove();
                            if (we.element.movedOn) continue;
                            we.waitingThread.interrupt();
                            break;
                        }
                        if (we.lockType != LockType.READ) continue;
                        listItr.remove();
                        if (we.element.movedOn) continue;
                        we.waitingThread.interrupt();
                    }
                }
            } else if (this.totalWriteCount == 0) {
                this.waitingThreadList.removeLast();
                if (!we.element.movedOn) {
                    we.waitingThread.interrupt();
                }
            }
        }
    }

    void acquireWriteLock() throws DeadlockDetectedException {
        this.acquireWriteLock(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireWriteLock(Transaction tx) throws DeadlockDetectedException {
        tx = this.getCurrentTransaction(tx);
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            tle.movedOn = false;
            while (this.totalWriteCount > tle.writeCount || this.totalReadCount > tle.readCount) {
                this.deadlockGuardedWait(tx, tle, LockType.WRITE);
            }
            this.registerWriteLockAcquired(tx, tle);
        }
        finally {
            tle.movedOn = true;
            --this.marked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean tryAcquireWriteLock(Transaction tx) {
        tx = this.getCurrentTransaction(tx);
        TxLockElement tle = this.getOrCreateLockElement(tx);
        try {
            tle.movedOn = false;
            if (this.totalWriteCount > tle.writeCount || this.totalReadCount > tle.readCount) {
                boolean bl = false;
                return bl;
            }
            this.registerWriteLockAcquired(tx, tle);
            boolean bl = true;
            return bl;
        }
        finally {
            tle.movedOn = true;
            --this.marked;
        }
    }

    synchronized void releaseWriteLock(Transaction tx) throws LockNotFoundException {
        TxLockElement tle = this.getLockElement(tx = this.getCurrentTransaction(tx));
        if (tle.writeCount == 0) {
            throw new LockNotFoundException("" + tx + " don't have writeLock");
        }
        --this.totalWriteCount;
        tle.writeCount--;
        if (tle.isFree()) {
            this.txLockElementMap.remove(tx);
            this.ragManager.lockReleased(this, tx);
        }
        if (this.totalWriteCount == 0 && this.waitingThreadList.size() > 0) {
            do {
                WaitElement we;
                if ((we = this.waitingThreadList.removeLast()).element.movedOn) continue;
                we.waitingThread.interrupt();
                if (we.lockType == LockType.WRITE) break;
            } while (this.waitingThreadList.size() > 0);
        }
    }

    int getWriteCount() {
        return this.totalWriteCount;
    }

    int getReadCount() {
        return this.totalReadCount;
    }

    synchronized int getWaitingThreadsCount() {
        return this.waitingThreadList.size();
    }

    @Override
    public synchronized boolean visit(StringLogger.LineLogger logger) {
        logger.logLine("Total lock count: readCount=" + this.totalReadCount + " writeCount=" + this.totalWriteCount + " for " + this.resource);
        logger.logLine("Waiting list:");
        Iterator wElements = this.waitingThreadList.iterator();
        while (wElements.hasNext()) {
            WaitElement we = (WaitElement)wElements.next();
            logger.logLine("[" + we.waitingThread + "(" + we.element.readCount + "r," + we.element.writeCount + "w)," + (Object)((Object)we.lockType) + "]");
            if (wElements.hasNext()) {
                logger.logLine(",");
                continue;
            }
            logger.logLine("");
        }
        logger.logLine("Locking transactions:");
        for (TxLockElement tle : this.txLockElementMap.values()) {
            logger.logLine("" + tle.tx + "(" + tle.readCount + "r," + tle.writeCount + "w)");
        }
        return true;
    }

    synchronized LockInfo info() {
        String id;
        ResourceType type;
        HashSet<LockingTransaction> lockingTxs = new HashSet<LockingTransaction>();
        HashSet<WaitingThread> waitingTxs = new HashSet<WaitingThread>();
        for (TxLockElement tle : this.txLockElementMap.values()) {
            lockingTxs.add(new LockingTransaction(tle.tx.toString(), tle.readCount, tle.writeCount));
        }
        for (WaitElement thread : this.waitingThreadList) {
            waitingTxs.add(WaitingThread.create(thread.element.tx.toString(), thread.element.readCount, thread.element.writeCount, thread.waitingThread, thread.since, thread.lockType == LockType.WRITE));
        }
        if (this.resource instanceof Node) {
            type = ResourceType.NODE;
            id = Long.toString(((Node)this.resource).getId());
        } else if (this.resource instanceof Relationship) {
            type = ResourceType.NODE;
            id = Long.toString(((Relationship)this.resource).getId());
        } else {
            type = ResourceType.OTHER;
            id = this.resource.toString();
        }
        return new LockInfo(type, id, this.totalReadCount, this.totalWriteCount, new ArrayList<LockingTransaction>(lockingTxs), new ArrayList<WaitingThread>(waitingTxs));
    }

    synchronized boolean acceptVisitorIfWaitedSinceBefore(Visitor<LockInfo> visitor, long waitStart) {
        for (WaitElement thread : this.waitingThreadList) {
            if (thread.since >= waitStart) continue;
            return visitor.visit(this.info());
        }
        return false;
    }

    public String toString() {
        return "RWLock[" + this.resource + "]";
    }

    private void registerReadLockAcquired(Transaction tx, TxLockElement tle) {
        this.registerLockAcquired(tx, tle);
        ++this.totalReadCount;
        tle.readCount++;
    }

    private void registerWriteLockAcquired(Transaction tx, TxLockElement tle) {
        this.registerLockAcquired(tx, tle);
        ++this.totalWriteCount;
        tle.writeCount++;
    }

    private void registerLockAcquired(Transaction tx, TxLockElement tle) {
        if (tle.isFree()) {
            this.ragManager.lockAcquired(this, tx);
        }
    }

    private TxLockElement getLockElement(Transaction tx) {
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            throw new LockNotFoundException("No transaction lock element found for " + tx);
        }
        return tle;
    }

    private void deadlockGuardedWait(Transaction tx, TxLockElement tle, LockType lockType) {
        this.ragManager.checkWaitOn(this, tx);
        this.waitingThreadList.addFirst(new WaitElement(tle, lockType, Thread.currentThread()));
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.ragManager.stopWaitOn(this, tx);
    }

    private TxLockElement getOrCreateLockElement(Transaction tx) {
        TxLockElement tle = this.txLockElementMap.get(tx);
        if (tle == null) {
            tle = new TxLockElement(tx);
            this.txLockElementMap.put(tx, tle);
        }
        return tle;
    }

    private Transaction getCurrentTransaction(Transaction tx) {
        if (tx == null && (tx = this.ragManager.getCurrentTransaction()) == null) {
            tx = new PlaceboTransaction();
        }
        return tx;
    }

    synchronized int getTxLockElementCount() {
        return this.txLockElementMap.size();
    }

    private static class PlaceboTransaction
    implements Transaction {
        private final Thread currentThread = Thread.currentThread();

        PlaceboTransaction() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof PlaceboTransaction)) {
                return false;
            }
            return this.currentThread.equals(((PlaceboTransaction)o).currentThread);
        }

        public int hashCode() {
            return this.currentThread.hashCode();
        }

        public void commit() {
            throw new UnsupportedOperationException();
        }

        public boolean delistResource(XAResource arg0, int arg1) {
            throw new UnsupportedOperationException();
        }

        public boolean enlistResource(XAResource arg0) {
            throw new UnsupportedOperationException();
        }

        public int getStatus() {
            throw new UnsupportedOperationException();
        }

        public void registerSynchronization(Synchronization arg0) {
            throw new UnsupportedOperationException();
        }

        public void rollback() {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() {
        }

        public String toString() {
            return "Placebo tx for thread " + this.currentThread;
        }
    }

    private static class WaitElement {
        private final TxLockElement element;
        private final LockType lockType;
        private final Thread waitingThread;
        private final long since = System.currentTimeMillis();

        WaitElement(TxLockElement element, LockType lockType, Thread thread) {
            this.element = element;
            this.lockType = lockType;
            this.waitingThread = thread;
        }
    }

    private static class TxLockElement {
        private final Transaction tx;
        private int readCount;
        private int writeCount;
        private boolean movedOn;

        TxLockElement(Transaction tx) {
            this.tx = tx;
        }

        boolean isFree() {
            return this.readCount == 0 && this.writeCount == 0;
        }
    }
}

