/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicRecordFetcher;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNeoStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyIndexStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipTypeStoreReader;
import org.neo4j.kernel.impl.util.StringLogger;

public class LegacyStore {
    public static final String FROM_VERSION = "NeoStore v0.9.9";
    private final File storageFileName;
    private LegacyNeoStoreReader neoStoreReader;
    private LegacyPropertyStoreReader propertyStoreReader;
    private LegacyNodeStoreReader nodeStoreReader;
    private LegacyDynamicRecordFetcher dynamicRecordFetcher;
    private LegacyPropertyIndexStoreReader propertyIndexStoreReader;
    private LegacyDynamicStoreReader propertyIndexKeyStoreReader;
    private LegacyRelationshipStoreReader relationshipStoreReader;
    private LegacyRelationshipTypeStoreReader relationshipTypeStoreReader;
    private LegacyDynamicStoreReader relationshipTypeNameStoreReader;
    private final StringLogger log;
    private final FileSystemAbstraction fs;

    public LegacyStore(FileSystemAbstraction fs, File storageFileName) throws IOException {
        this(fs, storageFileName, StringLogger.DEV_NULL);
    }

    public LegacyStore(FileSystemAbstraction fs, File storageFileName, StringLogger log) throws IOException {
        this.fs = fs;
        this.storageFileName = storageFileName;
        this.log = log;
        this.initStorage();
    }

    protected void initStorage() throws IOException {
        this.neoStoreReader = new LegacyNeoStoreReader(this.fs, this.getStorageFileName(), this.log);
        this.propertyStoreReader = new LegacyPropertyStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".propertystore.db"), this.log);
        this.dynamicRecordFetcher = new LegacyDynamicRecordFetcher(this.fs, new File(this.getStorageFileName().getPath() + ".propertystore.db.strings"), new File(this.getStorageFileName().getPath() + ".propertystore.db.arrays"), this.log);
        this.nodeStoreReader = new LegacyNodeStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".nodestore.db"));
        this.relationshipStoreReader = new LegacyRelationshipStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".relationshipstore.db"));
        this.relationshipTypeStoreReader = new LegacyRelationshipTypeStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".relationshiptypestore.db"));
        this.relationshipTypeNameStoreReader = new LegacyDynamicStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".relationshiptypestore.db.names"), "StringPropertyStore v0.9.9", this.log);
        this.propertyIndexStoreReader = new LegacyPropertyIndexStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".propertystore.db.index"));
        this.propertyIndexKeyStoreReader = new LegacyDynamicStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".propertystore.db.index.keys"), "StringPropertyStore v0.9.9", this.log);
    }

    public File getStorageFileName() {
        return this.storageFileName;
    }

    public LegacyNeoStoreReader getNeoStoreReader() {
        return this.neoStoreReader;
    }

    public LegacyPropertyStoreReader getPropertyStoreReader() {
        return this.propertyStoreReader;
    }

    public LegacyNodeStoreReader getNodeStoreReader() {
        return this.nodeStoreReader;
    }

    public LegacyRelationshipStoreReader getRelationshipStoreReader() {
        return this.relationshipStoreReader;
    }

    public LegacyDynamicRecordFetcher getDynamicRecordFetcher() {
        return this.dynamicRecordFetcher;
    }

    public LegacyPropertyIndexStoreReader getPropertyIndexStoreReader() {
        return this.propertyIndexStoreReader;
    }

    public LegacyDynamicStoreReader getPropertyIndexKeyStoreReader() {
        return this.propertyIndexKeyStoreReader;
    }

    public LegacyDynamicStoreReader getRelationshipTypeNameStoreReader() {
        return this.relationshipTypeNameStoreReader;
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    public LegacyRelationshipTypeStoreReader getRelationshipTypeStoreReader() {
        return this.relationshipTypeStoreReader;
    }

    public void close() throws IOException {
        this.neoStoreReader.close();
        this.propertyStoreReader.close();
        this.dynamicRecordFetcher.close();
        this.nodeStoreReader.close();
        this.relationshipStoreReader.close();
        this.relationshipTypeNameStoreReader.close();
        this.propertyIndexKeyStoreReader.close();
    }

    public void copyLegacyIndexStoreFile(File toDirectory) throws IOException {
        File legacyDirectory = this.storageFileName.getParentFile();
        File fromFile = new File(legacyDirectory, "index.db");
        if (fromFile.exists()) {
            File toFile = new File(toDirectory, "index.db");
            this.fs.copyFile(fromFile, toFile);
        }
    }
}

