/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Arrays;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;

public class Predicates {
    public static <T> Predicate<T> TRUE() {
        return new Predicate<T>(){

            @Override
            public boolean accept(T instance) {
                return true;
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<T> specification) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T instance) {
                return !specification.accept(instance);
            }
        };
    }

    public static <T> AndPredicate<T> and(Predicate<T> ... predicates) {
        return Predicates.and(Arrays.asList(predicates));
    }

    public static <T> AndPredicate<T> and(Iterable<Predicate<T>> predicates) {
        return new AndPredicate(predicates);
    }

    public static <T> OrPredicate<T> or(Predicate<T> ... predicates) {
        return Predicates.or(Arrays.asList(predicates));
    }

    public static <T> OrPredicate<T> or(Iterable<Predicate<T>> predicates) {
        return new OrPredicate(predicates);
    }

    public static <T> Predicate<T> equalTo(final T allowed) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T item) {
                return allowed == null ? item == null : allowed.equals(item);
            }
        };
    }

    public static <T> Predicate<T> in(T ... allowed) {
        return Predicates.in(Arrays.asList(allowed));
    }

    public static <T> Predicate<T> in(final Iterable<T> allowed) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T item) {
                for (Object allow : allowed) {
                    if (!allow.equals(item)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> notNull() {
        return new Predicate<T>(){

            @Override
            public boolean accept(T item) {
                return item != null;
            }
        };
    }

    public static <FROM, TO> Predicate<FROM> translate(final Function<FROM, TO> function, final Predicate<? super TO> specification) {
        return new Predicate<FROM>(){

            @Override
            public boolean accept(FROM item) {
                return specification.accept(function.apply(item));
            }
        };
    }

    public static class OrPredicate<T>
    implements Predicate<T> {
        private final Iterable<Predicate<T>> predicates;

        private OrPredicate(Iterable<Predicate<T>> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean accept(T instance) {
            for (Predicate<T> specification : this.predicates) {
                if (!specification.accept(instance)) continue;
                return true;
            }
            return false;
        }

        public AndPredicate<T> and(Predicate<T> ... predicates) {
            return Predicates.and(Iterables.prepend(this, Arrays.asList(predicates)));
        }

        public OrPredicate<T> or(Predicate<T> ... predicates) {
            Iterable iterable = Iterables.iterable(predicates);
            Iterable flatten = Iterables.flatten((Iterable[])new Iterable[]{this.predicates, iterable});
            return Predicates.or(flatten);
        }
    }

    public static class AndPredicate<T>
    implements Predicate<T> {
        private final Iterable<Predicate<T>> predicates;

        private AndPredicate(Iterable<Predicate<T>> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean accept(T instance) {
            for (Predicate<T> specification : this.predicates) {
                if (specification.accept(instance)) continue;
                return false;
            }
            return true;
        }

        public AndPredicate<T> and(Predicate<T> ... predicates) {
            Iterable iterable = Iterables.iterable(predicates);
            Iterable flatten = Iterables.flatten((Iterable[])new Iterable[]{this.predicates, iterable});
            return Predicates.and(flatten);
        }

        public OrPredicate<T> or(Predicate<T> ... predicates) {
            return Predicates.or(Iterables.prepend(this, Arrays.asList(predicates)));
        }
    }
}

