/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexIterable;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.DefaultGraphDatabaseDependencies;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.logging.Logging;

public class GraphDatabaseFactory {
    protected FileSystemAbstraction fileSystem;
    protected Logging logging;
    protected Iterable<Class<?>> settingsClasses;
    protected List<IndexProvider> indexProviders;
    protected List<KernelExtensionFactory<?>> kernelExtensions;
    protected List<CacheProvider> cacheProviders;
    protected List<TransactionInterceptorProvider> txInterceptorProviders;

    public GraphDatabaseFactory() {
        DefaultGraphDatabaseDependencies defaultDependencies = new DefaultGraphDatabaseDependencies();
        this.logging = defaultDependencies.logging();
        this.settingsClasses = defaultDependencies.settingsClasses();
        this.indexProviders = Iterables.toList(defaultDependencies.indexProviders());
        this.kernelExtensions = new ArrayList();
        for (KernelExtensionFactory<?> factory : defaultDependencies.kernelExtensions()) {
            this.kernelExtensions.add(factory);
        }
        this.cacheProviders = Iterables.toList(defaultDependencies.cacheProviders());
        this.txInterceptorProviders = Iterables.toList(defaultDependencies.transactionInterceptorProviders());
    }

    public GraphDatabaseService newEmbeddedDatabase(String path) {
        return this.newEmbeddedDatabaseBuilder(path).newGraphDatabase();
    }

    public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(final String path) {
        return new GraphDatabaseBuilder(new GraphDatabaseBuilder.DatabaseCreator(){

            @Override
            public GraphDatabaseService newDatabase(Map<String, String> config) {
                config.put("ephemeral", "false");
                GraphDatabaseDependencies dependencies = GraphDatabaseFactory.this.databaseDependencies();
                if ("true".equalsIgnoreCase(config.get(GraphDatabaseSettings.read_only.name()))) {
                    return new EmbeddedReadOnlyGraphDatabase(path, config, dependencies);
                }
                return new EmbeddedGraphDatabase(path, config, dependencies);
            }
        });
    }

    protected GraphDatabaseDependencies databaseDependencies() {
        return new GraphDatabaseDependencies(this.logging, this.settingsClasses, this.indexProviders, this.kernelExtensions, this.cacheProviders, this.txInterceptorProviders);
    }

    public Iterable<IndexProvider> getIndexProviders() {
        return this.indexProviders;
    }

    public void setIndexProviders(IndexIterable indexIterable) {
        this.indexProviders.clear();
        for (IndexProvider indexProvider : indexIterable) {
            this.indexProviders.add(indexProvider);
        }
    }

    public Iterable<KernelExtensionFactory<?>> getKernelExtension() {
        return this.kernelExtensions;
    }

    public void setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.kernelExtensions.clear();
        this.addKernelExtensions(newKernelExtensions);
    }

    public void addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        for (KernelExtensionFactory<?> newKernelExtension : newKernelExtensions) {
            this.addKernelExtension(newKernelExtension);
        }
    }

    public void addKernelExtension(KernelExtensionFactory<?> newKernelExtension) {
        this.kernelExtensions.add(newKernelExtension);
    }

    public void setCacheProviders(Iterable<CacheProvider> newCacheProviders) {
        this.cacheProviders.clear();
        for (CacheProvider newCacheProvider : newCacheProviders) {
            this.cacheProviders.add(newCacheProvider);
        }
    }

    public void setTransactionInterceptorProviders(Iterable<TransactionInterceptorProvider> transactionInterceptorProviders) {
        this.txInterceptorProviders.clear();
        for (TransactionInterceptorProvider newTxInterceptorProvider : transactionInterceptorProviders) {
            this.txInterceptorProviders.add(newTxInterceptorProvider);
        }
    }
}

