/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.Predicate;

public class DebugUtil {
    public static void printShortStackTrace(Throwable cause, int maxNumberOfStackLines) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        cause.printStackTrace(writer);
        writer.close();
        String string = stringWriter.getBuffer().toString();
        System.out.println(DebugUtil.firstLinesOf(string, maxNumberOfStackLines + 1));
    }

    public static String firstLinesOf(String string, int maxNumberOfLines) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        try {
            BufferedReader reader = new BufferedReader(new StringReader(string));
            String line = null;
            for (int count = 0; (line = reader.readLine()) != null && count < maxNumberOfLines; ++count) {
                writer.println(line);
            }
            writer.close();
            return stringWriter.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't happen", e);
        }
    }

    public static boolean currentStackTraceContains(Predicate<StackTraceElement> predicate) {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!predicate.accept(element)) continue;
            return true;
        }
        return false;
    }

    public static Predicate<StackTraceElement> classNameIs(final String className) {
        return new Predicate<StackTraceElement>(){

            @Override
            public boolean accept(StackTraceElement item) {
                return item.getClassName().equals(className);
            }
        };
    }

    public static Predicate<StackTraceElement> classNameContains(final String classNamePart) {
        return new Predicate<StackTraceElement>(){

            @Override
            public boolean accept(StackTraceElement item) {
                return item.getClassName().contains(classNamePart);
            }
        };
    }

    public static Predicate<StackTraceElement> classIs(final Class<?> cls) {
        return new Predicate<StackTraceElement>(){

            @Override
            public boolean accept(StackTraceElement item) {
                return item.getClassName().equals(cls.getName());
            }
        };
    }

    public static Predicate<StackTraceElement> classNameAndMethodAre(final String className, final String methodName) {
        return new Predicate<StackTraceElement>(){

            @Override
            public boolean accept(StackTraceElement item) {
                return item.getClassName().equals(className) && item.getMethodName().equals(methodName);
            }
        };
    }

    public static Predicate<StackTraceElement> classAndMethodAre(final Class<?> cls, final String methodName) {
        return new Predicate<StackTraceElement>(){

            @Override
            public boolean accept(StackTraceElement item) {
                return item.getClassName().equals(cls.getName()) && item.getMethodName().equals(methodName);
            }
        };
    }

    public static class CallCounter<T> {
        private final Map<T, AtomicInteger> calls = new HashMap<T, AtomicInteger>();
        private final String name;

        public CallCounter(String name) {
            this.name = name;
        }

        public CallCounter<T> printAtShutdown(final PrintStream out) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    CallCounter.this.print(out);
                }
            });
            return this;
        }

        public void inc(T key) {
            AtomicInteger count = this.calls.get(key);
            if (count == null) {
                count = new AtomicInteger();
                this.calls.put(key, count);
            }
            count.incrementAndGet();
        }

        private void print(PrintStream out) {
            out.println("Calls made regarding " + this.name + ":");
            for (Map.Entry<T, AtomicInteger> entry : this.calls.entrySet()) {
                out.println("\t" + entry.getKey() + ": " + entry.getValue());
            }
        }
    }

    private static class Stack {
        private final Throwable stackTrace;
        private final StackTraceElement[] elements;
        private final boolean considerMessage;

        Stack(Throwable stackTrace, boolean considerMessage) {
            this.stackTrace = stackTrace;
            this.considerMessage = considerMessage;
            this.elements = stackTrace.getStackTrace();
        }

        public int hashCode() {
            int hashCode = this.stackTrace.getMessage() == null || !this.considerMessage ? 31 : this.stackTrace.getMessage().hashCode();
            for (StackTraceElement element : this.stackTrace.getStackTrace()) {
                hashCode = hashCode * 9 + element.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Stack)) {
                return false;
            }
            Stack o = (Stack)obj;
            if (this.considerMessage && (this.stackTrace.getMessage() == null ? o.stackTrace.getMessage() != null : !this.stackTrace.getMessage().equals(o.stackTrace.getMessage()))) {
                return false;
            }
            if (this.elements.length != o.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i].equals(o.elements[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class StackTracer {
        private final Map<Stack, AtomicInteger> uniqueStackTraces = new HashMap<Stack, AtomicInteger>();
        private boolean considerMessages = true;

        public void add(Throwable t) {
            Stack key = new Stack(t, this.considerMessages);
            AtomicInteger count = this.uniqueStackTraces.get(key);
            if (count == null) {
                count = new AtomicInteger();
                this.uniqueStackTraces.put(key, count);
            }
            count.incrementAndGet();
        }

        public void print(PrintStream out) {
            long total = 0L;
            for (Map.Entry<Stack, AtomicInteger> entry : this.uniqueStackTraces.entrySet()) {
                out.println(entry.getValue() + " times:");
                entry.getKey().stackTrace.printStackTrace(out);
                total += (long)entry.getValue().get();
            }
            out.println("------");
            out.println("Total:" + total);
        }

        public StackTracer printAtShutdown(final PrintStream out) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    StackTracer.this.print(out);
                }
            });
            return this;
        }

        public StackTracer ignoreMessages() {
            this.considerMessages = false;
            return this;
        }
    }
}

