/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class CurrentDatabase {
    private final StoreVersionCheck storeVersionCheck;
    private Map<String, String> fileNamesToTypeDescriptors = new HashMap<String, String>();

    public CurrentDatabase(StoreVersionCheck storeVersionCheck) {
        this.storeVersionCheck = storeVersionCheck;
        this.fileNamesToTypeDescriptors.put("neostore", "NeoStore");
        this.fileNamesToTypeDescriptors.put("neostore.nodestore.db", "NodeStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db", "PropertyStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db.arrays", "ArrayPropertyStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db.index", "PropertyIndexStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db.index.keys", "StringPropertyStore");
        this.fileNamesToTypeDescriptors.put("neostore.propertystore.db.strings", "StringPropertyStore");
        this.fileNamesToTypeDescriptors.put("neostore.relationshipstore.db", "RelationshipStore");
        this.fileNamesToTypeDescriptors.put("neostore.relationshiptypestore.db", "RelationshipTypeStore");
        this.fileNamesToTypeDescriptors.put("neostore.relationshiptypestore.db.names", "StringPropertyStore");
    }

    public boolean storeFilesAtCurrentVersion(File storeDirectory) {
        for (String fileName : this.fileNamesToTypeDescriptors.keySet()) {
            String expectedVersion;
            if (this.storeVersionCheck.hasVersion(new File(storeDirectory, fileName), expectedVersion = CommonAbstractStore.buildTypeDescriptorAndVersion(this.fileNamesToTypeDescriptors.get(fileName)))) continue;
            return false;
        }
        return true;
    }
}

