/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.SystemException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.PropertyTracker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.LockElement;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;
import org.neo4j.kernel.impl.util.RelIdIterator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class NodeManager
implements Lifecycle {
    private long referenceNodeId = 0L;
    private final StringLogger logger;
    private final GraphDatabaseService graphDbService;
    private final Cache<NodeImpl> nodeCache;
    private final Cache<RelationshipImpl> relCache;
    private final CacheProvider cacheProvider;
    private final AbstractTransactionManager transactionManager;
    private final PropertyIndexManager propertyIndexManager;
    private final RelationshipTypeHolder relTypeHolder;
    private final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private final XaDataSourceManager xaDsm;
    private final NodeProxy.NodeLookup nodeLookup;
    private final RelationshipProxy.RelationshipLookups relationshipLookups;
    private final List<PropertyTracker<Node>> nodePropertyTrackers;
    private final List<PropertyTracker<Relationship>> relationshipPropertyTrackers;
    private static final int INDEX_COUNT = 2500;
    private static final int LOCK_STRIPE_COUNT = 32;
    private final ReentrantLock[] loadLocks = new ReentrantLock[32];
    private GraphProperties graphProperties;

    public NodeManager(Config config, StringLogger logger, GraphDatabaseService graphDb, AbstractTransactionManager transactionManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, RelationshipTypeHolder relationshipTypeHolder, CacheProvider cacheProvider, PropertyIndexManager propertyIndexManager, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache, XaDataSourceManager xaDsm) {
        this.logger = logger;
        this.graphDbService = graphDb;
        this.transactionManager = transactionManager;
        this.propertyIndexManager = propertyIndexManager;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.nodeLookup = nodeLookup;
        this.relationshipLookups = relationshipLookups;
        this.relTypeHolder = relationshipTypeHolder;
        this.cacheProvider = cacheProvider;
        this.nodeCache = nodeCache;
        this.relCache = relCache;
        this.xaDsm = xaDsm;
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock();
        }
        this.nodePropertyTrackers = new LinkedList<PropertyTracker<Node>>();
        this.relationshipPropertyTrackers = new LinkedList<PropertyTracker<Relationship>>();
        this.graphProperties = this.instantiateGraphProperties();
    }

    public GraphDatabaseService getGraphDbService() {
        return this.graphDbService;
    }

    public CacheProvider getCacheType() {
        return this.cacheProvider;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
        for (XaDataSource ds : this.xaDsm.getAllRegisteredDataSources()) {
            if (!ds.getName().equals("nioneodb")) continue;
            NameData[] relTypes = null;
            NameData[] propertyIndexes = null;
            relTypes = this.persistenceManager.loadAllRelationshipTypes();
            propertyIndexes = this.persistenceManager.loadPropertyIndexes(2500);
            this.addRawRelationshipTypes(relTypes);
            this.addPropertyIndexes(propertyIndexes);
            if (propertyIndexes.length >= 2500) continue;
            this.setHasAllpropertyIndexes(true);
        }
    }

    @Override
    public void stop() {
        this.clearCache();
    }

    @Override
    public void shutdown() {
        this.nodeCache.printStatistics();
        this.relCache.printStatistics();
        this.nodeCache.clear();
        this.relCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode() {
        long id = this.idGenerator.nextId(Node.class);
        NodeImpl node = new NodeImpl(id, true);
        NodeProxy proxy = new NodeProxy(id, this.nodeLookup);
        TransactionState transactionState = this.getTransactionState();
        transactionState.acquireWriteLock(proxy);
        boolean success = false;
        try {
            this.persistenceManager.nodeCreate(id);
            this.nodeCache.put(node);
            success = true;
            NodeProxy nodeProxy = proxy;
            return nodeProxy;
        }
        finally {
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    public NodeProxy newNodeProxyById(long id) {
        return new NodeProxy(id, this.nodeLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, RelationshipType type) {
        if (startNode == null || endNode == null || type == null) {
            throw new IllegalArgumentException("Null parameter, startNode=" + startNode + ", endNode=" + endNode + ", type=" + type);
        }
        if (!this.relTypeHolder.isValidRelationshipType(type)) {
            this.relTypeHolder.addValidRelationshipType(type.name(), true);
        }
        long startNodeId = startNode.getId();
        long endNodeId = endNode.getId();
        NodeImpl secondNode = this.getLightNode(endNodeId);
        if (secondNode == null) {
            this.setRollbackOnly();
            throw new NotFoundException("Second node[" + endNode.getId() + "] deleted");
        }
        long id = this.idGenerator.nextId(Relationship.class);
        int typeId = this.getRelationshipTypeIdFor(type);
        RelationshipImpl rel = this.newRelationshipImpl(id, startNodeId, endNodeId, type, typeId, true);
        RelationshipProxy proxy = new RelationshipProxy(id, this.relationshipLookups);
        TransactionState transactionState = this.getTransactionState();
        transactionState.acquireWriteLock(proxy);
        boolean success = false;
        TransactionState tx = transactionState;
        try {
            transactionState.acquireWriteLock(startNodeProxy);
            transactionState.acquireWriteLock(endNode);
            this.persistenceManager.relationshipCreate(id, typeId, startNodeId, endNodeId);
            if (startNodeId == endNodeId) {
                tx.getOrCreateCowRelationshipAddMap(startNode, typeId).add(id, RelIdArray.DirectionWrapper.BOTH);
            } else {
                tx.getOrCreateCowRelationshipAddMap(startNode, typeId).add(id, RelIdArray.DirectionWrapper.OUTGOING);
                tx.getOrCreateCowRelationshipAddMap(secondNode, typeId).add(id, RelIdArray.DirectionWrapper.INCOMING);
            }
            this.relCache.put(rel);
            success = true;
            RelationshipProxy relationshipProxy = proxy;
            return relationshipProxy;
        }
        finally {
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    private RelationshipImpl newRelationshipImpl(long id, long startNodeId, long endNodeId, RelationshipType type, int typeId, boolean newRel) {
        return new RelationshipImpl(id, startNodeId, endNodeId, typeId, newRel);
    }

    private ReentrantLock lockId(long id) {
        int stripe = (int)(id / 32768L) % 32;
        if (stripe < 0) {
            stripe *= -1;
        }
        ReentrantLock lock = this.loadLocks[stripe];
        lock.lock();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node getNodeByIdOrNull(long nodeId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return new NodeProxy(nodeId, this.nodeLookup);
        }
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            if (this.nodeCache.get(nodeId) != null) {
                NodeProxy nodeProxy = new NodeProxy(nodeId, this.nodeLookup);
                return nodeProxy;
            }
            NodeRecord record = this.persistenceManager.loadLightNode(nodeId);
            if (record == null) {
                Node node2 = null;
                return node2;
            }
            node = new NodeImpl(nodeId);
            this.nodeCache.put(node);
            NodeProxy nodeProxy = new NodeProxy(nodeId, this.nodeLookup);
            return nodeProxy;
        }
        finally {
            loadLock.unlock();
        }
    }

    public Node getNodeById(long nodeId) throws NotFoundException {
        Node node = this.getNodeByIdOrNull(nodeId);
        if (node == null) {
            throw new NotFoundException(String.format("Node %d not found", nodeId));
        }
        return node;
    }

    public RelationshipProxy newRelationshipProxyById(long id) {
        return new RelationshipProxy(id, this.relationshipLookups);
    }

    public Iterator<Node> getAllNodes() {
        PrefetchingIterator<Node> committedNodes = new PrefetchingIterator<Node>(){
            private long highId;
            private long currentId;
            {
                this.highId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            protected Node fetchNextOrNull() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            node = NodeManager.this.getNodeByIdOrNull(this.currentId);
                            if (node == null) ** GOTO lbl-1000
                            var2_3 = node;
                            return var2_3;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return null;
            }
        };
        final TransactionState txState = this.getTransactionState();
        if (!txState.hasChanges()) {
            return committedNodes;
        }
        final Set<Long> createdNodes = this.asSet(this.getCreatedNodes().iterator(RelIdArray.DirectionWrapper.OUTGOING));
        if (!createdNodes.isEmpty()) {
            committedNodes = new FilteringIterator<Node>(committedNodes, new Predicate<Node>(){

                @Override
                public boolean accept(Node node) {
                    return !createdNodes.contains(node.getId());
                }
            });
        }
        FilteringIterator<Node> filteredRemovedNodes = new FilteringIterator<Node>(committedNodes, new Predicate<Node>(){

            @Override
            public boolean accept(Node node) {
                return !txState.isDeleted(node);
            }
        });
        return new CombiningIterator<Node>(Arrays.asList(filteredRemovedNodes, new IteratorWrapper<Node, Long>(createdNodes.iterator()){

            @Override
            protected Node underlyingObjectToObject(Long id) {
                return NodeManager.this.getNodeById(id);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeImpl getLightNode(long nodeId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return node;
        }
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            node = this.nodeCache.get(nodeId);
            if (node != null) {
                NodeImpl nodeImpl = node;
                return nodeImpl;
            }
            NodeRecord record = this.persistenceManager.loadLightNode(nodeId);
            if (record == null) {
                NodeImpl nodeImpl = null;
                return nodeImpl;
            }
            node = new NodeImpl(nodeId);
            this.nodeCache.put(node);
            NodeImpl nodeImpl = node;
            return nodeImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
        NodeImpl node;
        if (lock != null) {
            lock.acquire(this.getTransactionState(), new NodeProxy(nodeId, this.nodeLookup));
        }
        if ((node = this.getLightNode(nodeId)) == null) {
            throw new NotFoundException(String.format("Node %d not found", nodeId));
        }
        return node;
    }

    public Node getReferenceNode() throws NotFoundException {
        if (this.referenceNodeId == -1L) {
            throw new NotFoundException("No reference node set");
        }
        return this.getNodeById(this.referenceNodeId);
    }

    public void setReferenceNodeId(long nodeId) {
        this.referenceNodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Relationship getRelationshipByIdOrNull(long relId) {
        RelationshipImpl relationship = this.relCache.get(relId);
        if (relationship != null) {
            return new RelationshipProxy(relId, this.relationshipLookups);
        }
        ReentrantLock loadLock = this.lockId(relId);
        try {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this.relationshipLookups);
                return relationshipProxy;
            }
            RelationshipRecord data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                Relationship relationship2 = null;
                return relationship2;
            }
            int typeId = data.getType();
            RelationshipType type = this.getRelationshipTypeById(typeId);
            if (type == null) {
                throw new NotFoundException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
            }
            long startNodeId = data.getFirstNode();
            long endNodeId = data.getSecondNode();
            relationship = this.newRelationshipImpl(relId, startNodeId, endNodeId, type, typeId, false);
            this.relCache.put(relationship);
            RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this.relationshipLookups);
            return relationshipProxy;
        }
        finally {
            loadLock.unlock();
        }
    }

    public Relationship getRelationshipById(long id) throws NotFoundException {
        Relationship relationship = this.getRelationshipByIdOrNull(id);
        if (relationship == null) {
            throw new NotFoundException(String.format("Relationship %d not found", id));
        }
        return relationship;
    }

    public Iterator<Relationship> getAllRelationships() {
        PrefetchingIterator<Relationship> committedRelationships = new PrefetchingIterator<Relationship>(){
            private long highId;
            private long currentId;
            {
                this.highId = NodeManager.this.getHighestPossibleIdInUse(Relationship.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            protected Relationship fetchNextOrNull() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            relationship = NodeManager.this.getRelationshipByIdOrNull(this.currentId);
                            if (relationship == null) ** GOTO lbl-1000
                            var2_3 = relationship;
                            return var2_3;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return null;
            }
        };
        final TransactionState txState = this.getTransactionState();
        if (!txState.hasChanges()) {
            return committedRelationships;
        }
        final Set<Long> createdRelationships = this.asSet(this.getCreatedRelationships().iterator(RelIdArray.DirectionWrapper.OUTGOING));
        if (!createdRelationships.isEmpty()) {
            committedRelationships = new FilteringIterator<Relationship>(committedRelationships, new Predicate<Relationship>(){

                @Override
                public boolean accept(Relationship relationship) {
                    return !createdRelationships.contains(relationship.getId());
                }
            });
        }
        FilteringIterator<Relationship> filteredRemovedRelationships = new FilteringIterator<Relationship>(committedRelationships, new Predicate<Relationship>(){

            @Override
            public boolean accept(Relationship relationship) {
                return !txState.isDeleted(relationship);
            }
        });
        return new CombiningIterator<Relationship>(Arrays.asList(filteredRemovedRelationships, new IteratorWrapper<Relationship, Long>(createdRelationships.iterator()){

            @Override
            protected Relationship underlyingObjectToObject(Long id) {
                return NodeManager.this.getRelationshipById(id);
            }
        }));
    }

    private Set<Long> asSet(RelIdIterator ids) {
        HashSet<Long> set = new HashSet<Long>();
        while (ids.hasNext()) {
            set.add(ids.next());
        }
        return set;
    }

    RelationshipType getRelationshipTypeById(int id) {
        return this.relTypeHolder.getRelationshipType(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipImpl getRelationshipForProxy(long relId, LockType lock) {
        RelationshipImpl relationship;
        if (lock != null) {
            lock.acquire(this.getTransactionState(), new RelationshipProxy(relId, this.relationshipLookups));
        }
        if ((relationship = this.relCache.get(relId)) != null) {
            return relationship;
        }
        ReentrantLock loadLock = this.lockId(relId);
        try {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                RelationshipImpl relationshipImpl = relationship;
                return relationshipImpl;
            }
            RelationshipRecord data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                throw new NotFoundException(String.format("Relationship %d not found", relId));
            }
            int typeId = data.getType();
            RelationshipType type = this.getRelationshipTypeById(typeId);
            if (type == null) {
                throw new NotFoundException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
            }
            relationship = this.newRelationshipImpl(relId, data.getFirstNode(), data.getSecondNode(), type, typeId, false);
            this.relCache.put(relationship);
            RelationshipImpl relationshipImpl = relationship;
            return relationshipImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public void removeNodeFromCache(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public void removeRelationshipFromCache(long id) {
        this.relCache.remove(id);
    }

    public void patchDeletedRelationshipNodes(long relId, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNodeNextRelId) {
        this.invalidateNode(firstNodeId, relId, firstNodeNextRelId);
        this.invalidateNode(secondNodeId, relId, secondNodeNextRelId);
    }

    private void invalidateNode(long nodeId, long relIdDeleted, long nextRelId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null && node.getRelChainPosition() == relIdDeleted) {
            node.setRelChainPosition(nextRelId);
        }
    }

    Object loadPropertyValue(PropertyData property) {
        return this.persistenceManager.loadPropertyValue(property);
    }

    long getRelationshipChainPosition(NodeImpl node) {
        return this.persistenceManager.getRelationshipChainPosition(node.getId());
    }

    Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, Long> getMoreRelationships(NodeImpl node) {
        boolean hasLoops;
        long nodeId = node.getId();
        long position = node.getRelChainPosition();
        Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> rels = this.persistenceManager.getMoreRelationships(nodeId, position);
        ArrayMap<Integer, RelIdArray> newRelationshipMap = new ArrayMap<Integer, RelIdArray>();
        ArrayList<RelationshipImpl> relsList = new ArrayList<RelationshipImpl>(150);
        Iterable<RelationshipRecord> loops = rels.first().get((Object)RelIdArray.DirectionWrapper.BOTH);
        boolean bl = hasLoops = loops != null;
        if (hasLoops) {
            this.populateLoadedRelationships(loops, relsList, RelIdArray.DirectionWrapper.BOTH, true, newRelationshipMap);
        }
        this.populateLoadedRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.OUTGOING), relsList, RelIdArray.DirectionWrapper.OUTGOING, hasLoops, newRelationshipMap);
        this.populateLoadedRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.INCOMING), relsList, RelIdArray.DirectionWrapper.INCOMING, hasLoops, newRelationshipMap);
        return Triplet.of(newRelationshipMap, relsList, rels.other());
    }

    private void populateLoadedRelationships(Iterable<RelationshipRecord> loadedRelationshipRecords, List<RelationshipImpl> relsList, RelIdArray.DirectionWrapper dir, boolean hasLoops, ArrayMap<Integer, RelIdArray> loadedRelationshipsOutputParameter) {
        for (RelationshipRecord rel : loadedRelationshipRecords) {
            long relId = rel.getId();
            RelationshipImpl relImpl = this.getOrCreateRelationshipFromCache(relsList, rel, relId);
            this.getOrCreateRelationships(hasLoops, relImpl.getTypeId(), loadedRelationshipsOutputParameter).add(relId, dir);
        }
    }

    private RelIdArray getOrCreateRelationships(boolean hasLoops, int typeId, ArrayMap<Integer, RelIdArray> loadedRelationships) {
        RelIdArray relIdArray = loadedRelationships.get(typeId);
        if (relIdArray == null) {
            relIdArray = hasLoops ? new RelIdArrayWithLoops(typeId) : new RelIdArray(typeId);
            loadedRelationships.put(typeId, relIdArray);
        }
        return relIdArray;
    }

    private RelationshipImpl getOrCreateRelationshipFromCache(List<RelationshipImpl> newlyCreatedRelationships, RelationshipRecord rel, long relId) {
        RelationshipImpl relImpl = this.relCache.get(relId);
        if (relImpl == null) {
            int relType = rel.getType();
            RelationshipType type = this.getRelationshipTypeById(relType);
            assert (type != null);
            relImpl = this.newRelationshipImpl(relId, rel.getFirstNode(), rel.getSecondNode(), type, relType, false);
            newlyCreatedRelationships.add(relImpl);
        }
        return relImpl;
    }

    void putAllInRelCache(Collection<RelationshipImpl> relationships) {
        this.relCache.putAll(relationships);
    }

    ArrayMap<Integer, PropertyData> loadGraphProperties(boolean light) {
        return this.persistenceManager.graphLoadProperties(light);
    }

    ArrayMap<Integer, PropertyData> loadProperties(NodeImpl node, boolean light) {
        return this.persistenceManager.loadNodeProperties(node.getId(), light);
    }

    ArrayMap<Integer, PropertyData> loadProperties(RelationshipImpl relationship, boolean light) {
        return this.persistenceManager.loadRelProperties(relationship.getId(), light);
    }

    public void clearCache() {
        this.nodeCache.clear();
        this.relCache.clear();
        this.graphProperties = this.instantiateGraphProperties();
    }

    public Iterable<? extends Cache<?>> caches() {
        return Arrays.asList(this.nodeCache, this.relCache);
    }

    void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            this.logger.debug("Failed to set transaction rollback only", e);
        }
        catch (SystemException se) {
            this.logger.error("Failed to set transaction rollback only", se);
        }
    }

    public <T extends PropertyContainer> T indexPutIfAbsent(Index<T> index, T entity, String key, Object value) {
        PropertyContainer existing = (PropertyContainer)index.get(key, value).getSingle();
        if (existing != null) {
            return (T)existing;
        }
        IndexLock lock = new IndexLock(index.getName(), key);
        TransactionState state = this.getTransactionState();
        LockElement writeLock = state.acquireWriteLock(lock);
        existing = (PropertyContainer)index.get(key, value).getSingle();
        if (existing != null) {
            writeLock.release();
            return (T)existing;
        }
        index.add(entity, key, value);
        return null;
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.idGenerator.getHighestPossibleIdInUse(clazz);
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.idGenerator.getNumberOfIdsInUse(clazz);
    }

    public void removeRelationshipTypeFromCache(int id) {
        this.relTypeHolder.removeRelType(id);
    }

    void addPropertyIndexes(NameData[] propertyIndexes) {
        this.propertyIndexManager.addPropertyIndexes(propertyIndexes);
    }

    void setHasAllpropertyIndexes(boolean hasAll) {
        this.propertyIndexManager.setHasAll(hasAll);
    }

    PropertyIndex getIndexFor(int keyId, TransactionState tx) {
        return this.propertyIndexManager.getIndexFor(keyId, tx);
    }

    PropertyIndex[] index(String key, TransactionState tx) {
        return this.propertyIndexManager.index(key, tx);
    }

    boolean hasAllPropertyIndexes() {
        return this.propertyIndexManager.hasAll();
    }

    boolean hasIndexFor(int keyId) {
        return this.propertyIndexManager.hasIndexFor(keyId);
    }

    PropertyIndex createPropertyIndex(String key) {
        return this.propertyIndexManager.createPropertyIndex(key, this.getTransactionState());
    }

    Integer getRelationshipTypeIdFor(RelationshipType type) {
        return this.relTypeHolder.getIdFor(type);
    }

    void addRawRelationshipTypes(NameData[] relTypes) {
        this.relTypeHolder.addRawRelationshipTypes(relTypes);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.relTypeHolder.getRelationshipTypes();
    }

    private <T extends PropertyContainer> void deleteFromTrackers(Primitive primitive, List<PropertyTracker<T>> trackers) {
        if (!trackers.isEmpty()) {
            Iterable<String> propertyKeys = primitive.getPropertyKeys(this);
            PropertyContainer proxy = primitive.asProxy(this);
            for (String key : propertyKeys) {
                Object value = primitive.getProperty(this, key);
                for (PropertyTracker<PropertyContainer> propertyTracker : trackers) {
                    propertyTracker.propertyRemoved(proxy, key, value);
                }
            }
        }
    }

    ArrayMap<Integer, PropertyData> deleteNode(NodeImpl node, TransactionState tx) {
        this.deleteFromTrackers(node, this.nodePropertyTrackers);
        tx.deletePrimitive(node);
        return this.persistenceManager.nodeDelete(node.getId());
    }

    PropertyData nodeAddProperty(NodeImpl node, PropertyIndex index, Object value) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyAdded(this.getNodeById(node.getId()), index.getKey(), value);
            }
        }
        return this.persistenceManager.nodeAddProperty(node.getId(), index, value);
    }

    PropertyData nodeChangeProperty(NodeImpl node, PropertyData property, Object value, TransactionState tx) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyChanged(this.getNodeById(node.getId()), this.getIndexFor(property.getIndex(), tx).getKey(), property.getValue(), value);
            }
        }
        return this.persistenceManager.nodeChangeProperty(node.getId(), property, value);
    }

    void nodeRemoveProperty(NodeImpl node, PropertyData property, TransactionState tx) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyRemoved(this.getNodeById(node.getId()), this.getIndexFor(property.getIndex(), tx).getKey(), property.getValue());
            }
        }
        this.persistenceManager.nodeRemoveProperty(node.getId(), property);
    }

    PropertyData graphAddProperty(PropertyIndex index, Object value) {
        return this.persistenceManager.graphAddProperty(index, value);
    }

    PropertyData graphChangeProperty(PropertyData property, Object value) {
        return this.persistenceManager.graphChangeProperty(property, value);
    }

    void graphRemoveProperty(PropertyData property) {
        this.persistenceManager.graphRemoveProperty(property);
    }

    ArrayMap<Integer, PropertyData> deleteRelationship(RelationshipImpl rel, TransactionState tx) {
        this.deleteFromTrackers(rel, this.relationshipPropertyTrackers);
        tx.deletePrimitive(rel);
        return this.persistenceManager.relDelete(rel.getId());
    }

    PropertyData relAddProperty(RelationshipImpl rel, PropertyIndex index, Object value) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyAdded(this.getRelationshipById(rel.getId()), index.getKey(), value);
            }
        }
        return this.persistenceManager.relAddProperty(rel.getId(), index, value);
    }

    PropertyData relChangeProperty(RelationshipImpl rel, PropertyData property, Object value, TransactionState tx) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyChanged(this.getRelationshipById(rel.getId()), this.getIndexFor(property.getIndex(), tx).getKey(), property.getValue(), value);
            }
        }
        return this.persistenceManager.relChangeProperty(rel.getId(), property, value);
    }

    void relRemoveProperty(RelationshipImpl rel, PropertyData property, TransactionState tx) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyRemoved(this.getRelationshipById(rel.getId()), this.getIndexFor(property.getIndex(), tx).getKey(), property.getValue());
            }
        }
        this.persistenceManager.relRemoveProperty(rel.getId(), property);
    }

    public NodeImpl getNodeIfCached(long nodeId) {
        return this.nodeCache.get(nodeId);
    }

    public RelationshipImpl getRelIfCached(long nodeId) {
        return this.relCache.get(nodeId);
    }

    void addRelationshipType(NameData type) {
        this.relTypeHolder.addRawRelationshipType(type);
    }

    void addPropertyIndex(NameData index) {
        this.propertyIndexManager.addPropertyIndex(index);
    }

    RelIdArray getCreatedNodes() {
        return this.persistenceManager.getCreatedNodes();
    }

    RelIdArray getCreatedRelationships() {
        return this.persistenceManager.getCreatedRelationships();
    }

    boolean nodeCreated(long nodeId) {
        return this.persistenceManager.isNodeCreated(nodeId);
    }

    boolean relCreated(long relId) {
        return this.persistenceManager.isRelationshipCreated(relId);
    }

    public String getKeyForProperty(PropertyData property, TransactionState tx) {
        return this.propertyIndexManager.getIndexFor(property.getIndex(), tx).getKey();
    }

    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.relTypeHolder;
    }

    public void addNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.add(nodePropertyTracker);
    }

    public void removeNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.remove(nodePropertyTracker);
    }

    public void addRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.add(relationshipPropertyTracker);
    }

    public void removeRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.remove(relationshipPropertyTracker);
    }

    public boolean isDeleted(PropertyContainer entity) {
        if (entity instanceof Node) {
            return this.isDeleted((Node)entity);
        }
        if (entity instanceof Relationship) {
            return this.isDeleted((Relationship)entity);
        }
        throw new IllegalArgumentException("Unknown entity type: " + entity + ", " + entity.getClass());
    }

    public boolean isDeleted(Node resource) {
        return this.getTransactionState().isDeleted(resource);
    }

    public boolean isDeleted(Relationship resource) {
        return this.getTransactionState().isDeleted(resource);
    }

    PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    private GraphProperties instantiateGraphProperties() {
        return new GraphProperties(this);
    }

    public GraphProperties getGraphProperties() {
        return this.graphProperties;
    }

    public void removeGraphPropertiesFromCache() {
        this.graphProperties = this.instantiateGraphProperties();
    }

    void updateCacheSize(NodeImpl node, int newSize) {
        this.nodeCache.updateSize(node, newSize);
    }

    void updateCacheSize(RelationshipImpl rel, int newSize) {
        this.relCache.updateSize(rel, newSize);
    }

    TransactionState getTransactionState() {
        return this.transactionManager.getTransactionState();
    }

    public static class IndexLock {
        private final String index;
        private final String key;

        public IndexLock(String index, String key) {
            this.index = index;
            this.key = key;
        }

        public String getIndex() {
            return this.index;
        }

        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexLock other = (IndexLock)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            return "IndexLock[" + this.index + ":" + this.key + "]";
        }
    }
}

