/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashSet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

enum PrimitiveTypeFetcher {
    NODE{

        @Override
        long getId(Path source) {
            return source.endNode().getId();
        }

        @Override
        boolean idEquals(Path source, long idToCompare) {
            return this.getId(source) == idToCompare;
        }

        @Override
        boolean containsDuplicates(Path source) {
            HashSet<Node> nodes = new HashSet<Node>();
            for (Node node : source.reverseNodes()) {
                if (nodes.add(node)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    RELATIONSHIP{

        @Override
        long getId(Path source) {
            return source.lastRelationship().getId();
        }

        @Override
        boolean idEquals(Path source, long idToCompare) {
            Relationship relationship = source.lastRelationship();
            return relationship != null && relationship.getId() == idToCompare;
        }

        @Override
        boolean containsDuplicates(Path source) {
            HashSet<Relationship> relationships = new HashSet<Relationship>();
            for (Relationship relationship : source.reverseRelationships()) {
                if (relationships.add(relationship)) continue;
                return true;
            }
            return false;
        }
    };


    abstract long getId(Path var1);

    abstract boolean idEquals(Path var1, long var2);

    abstract boolean containsDuplicates(Path var1);
}

