/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.neo4j.helpers.Pair;

public class Triplet<T1, T2, T3>
extends Pair<T1, Pair<T2, T3>> {
    private final T1 first;
    private final T2 second;
    private final T3 third;

    public static <T1, T2, T3> Triplet<T1, T2, T3> of(T1 first, T2 second, T3 third) {
        return new Triplet<T1, T2, T3>(first, second, third);
    }

    private Triplet(T1 first, T2 second, T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public T1 first() {
        return this.first;
    }

    public T2 second() {
        return this.second;
    }

    public T3 third() {
        return this.third;
    }

    @Override
    public Pair<T2, T3> other() {
        return Pair.of(this.second, this.third);
    }

    @Override
    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ")";
    }

    @Override
    public int hashCode() {
        return (31 * Triplet.hashCode(this.first) | Triplet.hashCode(this.second)) * 31 | Triplet.hashCode(this.third);
    }

    @Override
    public boolean equals(Object obj) {
        Pair that;
        Object other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof Triplet) {
            Triplet that2 = (Triplet)obj;
            return Triplet.equals(this.first, that2.first) && Triplet.equals(this.second, that2.second) && Triplet.equals(this.third, that2.third);
        }
        if (obj instanceof Pair && (other = (that = (Pair)obj).other()) instanceof Pair) {
            Pair pair = (Pair)other;
            return Triplet.equals(this.first, that.first()) && Triplet.equals(this.second, pair.first()) && Triplet.equals(this.third, pair.other());
        }
        return false;
    }
}

