/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.neo4j.helpers.Predicate;

public class Exceptions {
    private static final String UNEXPECTED_MESSAGE = "Unexpected Exception";

    public static <T extends Throwable> T withCause(T exception, Throwable cause) {
        try {
            exception.initCause(cause);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return exception;
    }

    public static RuntimeException launderedException(Throwable exception) {
        return Exceptions.launderedException(UNEXPECTED_MESSAGE, exception);
    }

    public static RuntimeException launderedException(String messageForUnexpected, Throwable exception) {
        return Exceptions.launderedException(RuntimeException.class, messageForUnexpected, exception);
    }

    public static <T extends Throwable> T launderedException(Class<T> type, Throwable exception) {
        return Exceptions.launderedException(type, UNEXPECTED_MESSAGE, exception);
    }

    public static <T extends Throwable> T launderedException(Class<T> type, String messageForUnexpected, Throwable exception) {
        if (type.isInstance(exception)) {
            return (T)((Throwable)type.cast(exception));
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception instanceof InvocationTargetException) {
            return Exceptions.launderedException(type, messageForUnexpected, ((InvocationTargetException)exception).getTargetException());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(messageForUnexpected, exception);
    }

    public static Throwable peel(Throwable exception, Predicate<Throwable> toPeel) {
        while (exception != null && toPeel.accept(exception)) {
            exception = exception.getCause();
        }
        return exception;
    }

    public static Predicate<Throwable> exceptionsOfType(final Class<? extends Throwable> ... types) {
        return new Predicate<Throwable>(){

            @Override
            public boolean accept(Throwable item) {
                for (Class type : types) {
                    if (!type.isAssignableFrom(item.getClass())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Throwable rootCause(Throwable caughtException) {
        if (null == caughtException) {
            throw new IllegalArgumentException("Cannot obtain rootCause from (null)");
        }
        Throwable root = caughtException;
        for (Throwable cause = root.getCause(); null != cause; cause = cause.getCause()) {
            root = cause;
        }
        return root;
    }

    public static String stringify(Throwable cause) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream target = new PrintStream((OutputStream)bytes, true, "UTF-8");
            cause.printStackTrace(target);
            target.flush();
            return bytes.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            cause.printStackTrace(System.err);
            return "[ERROR: Unable to serialize stacktrace, UTF-8 not supported.]";
        }
    }

    public static String stringify(Thread thread, StackTraceElement[] elements) {
        StringBuilder builder = new StringBuilder("\"" + thread.getName() + "\"" + (thread.isDaemon() ? " daemon" : "") + " prio=" + thread.getPriority() + " tid=" + thread.getId() + " " + thread.getState().name().toLowerCase() + "\n");
        builder.append("   " + Thread.State.class.getName() + ": " + thread.getState().name().toUpperCase() + "\n");
        for (StackTraceElement element : elements) {
            builder.append("      at " + element.getClassName() + "." + element.getMethodName());
            if (element.isNativeMethod()) {
                builder.append("(Native method)");
            } else if (element.getFileName() == null) {
                builder.append("(Unknown source)");
            } else {
                builder.append("(" + element.getFileName() + ":" + element.getLineNumber() + ")");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static boolean contains(Throwable cause, Class ... anyOfTheseClasses) {
        while (cause != null) {
            for (Class cls : anyOfTheseClasses) {
                if (!cls.isInstance(cause)) continue;
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    private Exceptions() {
    }

    public static <E extends Throwable> E combine(E first, E second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        Object current = first;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        current.initCause(second);
        return first;
    }
}

