/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid {
    public static final Seed DEFAULT_SEED = new Seed(){
        private long nextSequenceId = 0L;
        private final Random r = new Random();

        @Override
        public synchronized long nextSequenceId() {
            return this.nextSequenceId++;
        }

        @Override
        public long nextRandomLong() {
            return this.r.nextLong();
        }
    };
    private static final int FORMAT_ID = 1313164849;
    private static final byte[] INSTANCE_ID = new byte[]{78, 69, 79, 75, 69, 82, 78, 76, 0};
    private final byte[] globalId;
    private final byte[] branchId;
    private final int formatId;
    private volatile int hashCode = 0;

    public static byte[] getNewGlobalId(Seed seed, int localId) {
        byte[] globalId = Arrays.copyOf(INSTANCE_ID, INSTANCE_ID.length + 20);
        ByteBuffer.wrap(globalId, INSTANCE_ID.length, 20).putLong(seed.nextRandomLong()).putLong(seed.nextSequenceId()).putInt(localId);
        return globalId;
    }

    static boolean isThisTm(byte[] globalId) {
        if (globalId.length < INSTANCE_ID.length) {
            return false;
        }
        for (int i = 0; i < INSTANCE_ID.length; ++i) {
            if (globalId[i] == INSTANCE_ID[i]) continue;
            return false;
        }
        return true;
    }

    public XidImpl(byte[] globalId, byte[] resourceId) {
        this(globalId, resourceId, 1313164849);
    }

    public XidImpl(byte[] globalId, byte[] resourceId, int formatId) {
        if (globalId.length > 64) {
            throw new IllegalArgumentException("GlobalId length to long, " + globalId.length);
        }
        if (resourceId.length > 64) {
            throw new IllegalArgumentException("BranchId (resource id) to long, " + resourceId.length);
        }
        this.globalId = globalId;
        this.branchId = resourceId;
        this.formatId = formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        return (byte[])this.branchId.clone();
    }

    @Override
    public int getFormatId() {
        return 1313164849;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Xid)) {
            return false;
        }
        return Arrays.equals(this.globalId, ((Xid)o).getGlobalTransactionId()) && Arrays.equals(this.branchId, ((Xid)o).getBranchQualifier());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int calcHash = 0;
            for (int i = 0; i < 3 && i < this.globalId.length; ++i) {
                calcHash += this.globalId[this.globalId.length - i - 1] << i * 8;
            }
            if (this.branchId.length > 0) {
                calcHash += this.branchId[0] << 24;
            }
            this.hashCode = 3217 * calcHash;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("GlobalId[");
        int baseLength = INSTANCE_ID.length + 8 + 8;
        if (this.globalId.length == baseLength || this.globalId.length == baseLength + 4) {
            for (int i = 0; i < INSTANCE_ID.length - 1; ++i) {
                buf.append((char)this.globalId[i]);
            }
            ByteBuffer byteBuf = ByteBuffer.wrap(this.globalId);
            byteBuf.position(INSTANCE_ID.length);
            long time = byteBuf.getLong();
            long sequence = byteBuf.getLong();
            buf.append('|');
            buf.append(time);
            buf.append('|');
            buf.append(sequence);
            if (byteBuf.hasRemaining()) {
                buf.append('|').append(byteBuf.getInt());
            }
        } else {
            buf.append("UNKNOWN_ID");
        }
        buf.append("], BranchId[ ");
        for (int i = 0; i < this.branchId.length; ++i) {
            buf.append(this.branchId[i] + " ");
        }
        buf.append("]");
        return buf.toString();
    }

    static interface Seed {
        public long nextRandomLong();

        public long nextSequenceId();
    }
}

