/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public class StoreVersionCheck {
    private FileSystemAbstraction fs;

    public StoreVersionCheck(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasVersion(File storeFile, String expectedVersion) {
        AbstractInterruptibleChannel fileChannel = null;
        byte[] expectedVersionBytes = UTF8.encode(expectedVersion);
        try {
            if (!this.fs.fileExists(storeFile)) {
                boolean bl = false;
                return bl;
            }
            fileChannel = this.fs.open(storeFile, "r");
            if (((FileChannel)fileChannel).size() < (long)expectedVersionBytes.length) {
                boolean bl = false;
                return bl;
            }
            String actualVersion = this.readVersion((FileChannel)fileChannel, expectedVersionBytes.length);
            if (expectedVersion.equals(actualVersion)) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String readVersion(FileChannel fileChannel, int bytesToRead) throws IOException {
        fileChannel.position(fileChannel.size() - (long)bytesToRead);
        byte[] foundVersionBytes = new byte[bytesToRead];
        fileChannel.read(ByteBuffer.wrap(foundVersionBytes));
        return UTF8.decode(foundVersionBytes);
    }
}

