/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class PropertyIndexManager
extends LifecycleAdapter {
    private static final PropertyIndex[] EMPTY_PROPERTY_INDEXES = new PropertyIndex[0];
    private Map<String, PropertyIndex[]> indexMap = new CopyOnWriteHashMap<String, PropertyIndex[]>();
    private Map<Integer, PropertyIndex> idToIndexMap = new CopyOnWriteHashMap<Integer, PropertyIndex>();
    private final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private boolean hasAll = false;

    public PropertyIndexManager(PersistenceManager persistenceManager, EntityIdGenerator idGenerator) {
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
    }

    @Override
    public void stop() {
        this.indexMap = new ConcurrentHashMap<String, PropertyIndex[]>();
        this.idToIndexMap = new ConcurrentHashMap<Integer, PropertyIndex>();
    }

    public PropertyIndex[] index(String key, TransactionState state) {
        PropertyIndex[] existing = null;
        if (key != null) {
            PropertyIndex added;
            existing = this.indexMap.get(key);
            if (state != null && (added = state.getPropertyIndex(key)) != null) {
                PropertyIndex[] fullList;
                if (existing != null) {
                    fullList = new PropertyIndex[existing.length + 1];
                    System.arraycopy(existing, 0, fullList, 0, existing.length);
                } else {
                    fullList = new PropertyIndex[1];
                }
                fullList[fullList.length - 1] = added;
                return fullList;
            }
        }
        if (existing == null) {
            existing = EMPTY_PROPERTY_INDEXES;
        }
        return existing;
    }

    void setHasAll(boolean status) {
        this.hasAll = status;
    }

    boolean hasAll() {
        return this.hasAll;
    }

    public boolean hasIndexFor(int keyId) {
        return this.idToIndexMap.get(keyId) != null;
    }

    void addPropertyIndexes(NameData[] indexes) {
        for (NameData rawIndex : indexes) {
            this.addPropertyIndex(new PropertyIndex(rawIndex.getName(), rawIndex.getId()));
        }
    }

    void addPropertyIndex(NameData rawIndex) {
        this.addPropertyIndex(new PropertyIndex(rawIndex.getName(), rawIndex.getId()));
    }

    public PropertyIndex getIndexFor(int keyId, TransactionState state) {
        PropertyIndex index = this.idToIndexMap.get(keyId);
        if (index == null) {
            PropertyIndex added;
            if (state != null && (added = state.getPropertyIndex(keyId)) != null) {
                return added;
            }
            String indexString = this.persistenceManager.loadIndex(keyId);
            if (indexString == null) {
                throw new NotFoundException("Index not found [" + keyId + "]");
            }
            index = new PropertyIndex(indexString, keyId);
            this.addPropertyIndex(index);
        }
        return index;
    }

    synchronized void addPropertyIndex(PropertyIndex index) {
        PropertyIndex[] list = this.indexMap.get(index.getKey());
        if (list == null) {
            list = new PropertyIndex[]{index};
        } else {
            PropertyIndex[] extendedList = new PropertyIndex[list.length + 1];
            System.arraycopy(list, 0, extendedList, 0, list.length);
            extendedList[list.length] = index;
            list = extendedList;
        }
        this.indexMap.put(index.getKey(), list);
        this.idToIndexMap.put(index.getKeyId(), index);
    }

    PropertyIndex createPropertyIndex(String key, TransactionState state) {
        if (state == null) {
            throw new NotInTransactionException("Unable to create property index for " + key);
        }
        PropertyIndex index = state.getPropertyIndex(key);
        if (index != null) {
            return index;
        }
        int id = (int)this.idGenerator.nextId(PropertyIndex.class);
        index = new PropertyIndex(key, id);
        state.addPropertyIndex(index);
        this.persistenceManager.createPropertyIndex(key, id);
        return index;
    }
}

