/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class RelationshipTypeHolder
extends LifecycleAdapter {
    private Map<String, Integer> relTypes = new CopyOnWriteHashMap<String, Integer>();
    private Map<Integer, RelationshipTypeImpl> relTranslation = new CopyOnWriteHashMap<Integer, RelationshipTypeImpl>();
    private final TransactionManager transactionManager;
    private final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private final RelationshipTypeCreator relTypeCreator;

    public RelationshipTypeHolder(TransactionManager transactionManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, RelationshipTypeCreator relTypeCreator) {
        this.transactionManager = transactionManager;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.relTypeCreator = relTypeCreator;
    }

    void addRawRelationshipTypes(NameData[] types) {
        HashMap<String, Integer> newTypes = new HashMap<String, Integer>();
        HashMap<Integer, RelationshipTypeImpl> newTranslation = new HashMap<Integer, RelationshipTypeImpl>();
        for (NameData type : types) {
            this.addType(type, newTypes, newTranslation);
        }
        this.relTypes.putAll(newTypes);
        this.relTranslation.putAll(newTranslation);
    }

    void addRawRelationshipType(NameData type) {
        this.addType(type, this.relTypes, this.relTranslation);
    }

    private void addType(NameData type, Map<String, Integer> relTypes, Map<Integer, RelationshipTypeImpl> relTranslation) {
        RelationshipTypeImpl relType = new RelationshipTypeImpl(type.getName(), type.getId());
        relTypes.put(type.getName(), type.getId());
        relTranslation.put(type.getId(), relType);
    }

    public RelationshipType addValidRelationshipType(String name, boolean create) {
        Integer id = this.relTypes.get(name);
        if (id == null) {
            if (!create) {
                return null;
            }
            id = this.createRelationshipType(name);
            RelationshipTypeImpl type = new RelationshipTypeImpl(name, id);
            this.relTranslation.put(id, type);
            return type;
        }
        RelationshipTypeImpl relType = this.relTranslation.get(id);
        if (relType == null) {
            relType = new RelationshipTypeImpl(name, id);
            this.relTranslation.put(id, relType);
        }
        return relType;
    }

    boolean isValidRelationshipType(RelationshipType type) {
        return this.relTypes.get(type.name()) != null;
    }

    private synchronized int createRelationshipType(String name) {
        Integer id = this.relTypes.get(name);
        if (id != null) {
            return id;
        }
        id = this.relTypeCreator.getOrCreate(this.transactionManager, this.idGenerator, this.persistenceManager, this, name);
        this.addRelType(name, id);
        return id;
    }

    void addRelType(String name, Integer id) {
        this.relTypes.put(name, id);
    }

    void removeRelType(String name) {
        this.relTypes.remove(name);
    }

    void removeRelType(int id) {
        RelationshipTypeImpl relType = this.relTranslation.remove(id);
        if (relType != null) {
            this.relTypes.remove(relType.name);
        }
    }

    Integer getIdFor(RelationshipType type) {
        return this.getIdFor(type.name());
    }

    public Integer getIdFor(String name) {
        return this.relTypes.get(name);
    }

    public RelationshipType getRelationshipType(int id) {
        return this.relTranslation.get(id);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        ArrayList<RelationshipType> relTypeList = new ArrayList<RelationshipType>();
        for (Map.Entry<String, Integer> type : this.relTypes.entrySet()) {
            relTypeList.add(new RelationshipTypeImpl(type.getKey(), type.getValue()));
        }
        return relTypeList;
    }

    @Override
    public void stop() {
        this.relTypes.clear();
        this.relTranslation.clear();
    }

    public static class RelationshipTypeImpl
    implements RelationshipType {
        private final String name;
        private final int id;

        RelationshipTypeImpl(String name, int id) {
            assert (name != null);
            this.name = name;
            this.id = id;
        }

        @Override
        public String name() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RelationshipType)) {
                return false;
            }
            return this.name.equals(((RelationshipType)o).name());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

