/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import javax.transaction.Transaction;
import org.neo4j.graphdb.Lock;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;

public class LockElement
implements Lock {
    private Object resource;
    private final LockType lockType;
    private final LockManager lockManager;

    public LockElement(Object resource, LockType type, LockManager lockManager) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        this.resource = resource;
        this.lockType = type;
        this.lockManager = lockManager;
    }

    private boolean released() {
        return this.resource == null;
    }

    public boolean releaseIfAcquired() {
        return this.releaseIfAcquired(null);
    }

    public boolean releaseIfAcquired(Transaction tx) {
        if (this.released()) {
            return false;
        }
        this.lockType.release(this.lockManager, this.resource, tx);
        this.resource = null;
        return true;
    }

    @Override
    public void release() {
        if (!this.releaseIfAcquired()) {
            throw new IllegalStateException("Already released");
        }
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.lockType.name()).append("-LockElement[");
        if (this.released()) {
            string.append("released,");
        }
        string.append(this.resource);
        return string.append(']').toString();
    }
}

