/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.cache.SizeOfObject;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class RelIdArray
implements SizeOfObject {
    private static final DirectionWrapper[] DIRECTIONS_FOR_OUTGOING = new DirectionWrapper[]{DirectionWrapper.OUTGOING, DirectionWrapper.BOTH};
    private static final DirectionWrapper[] DIRECTIONS_FOR_INCOMING = new DirectionWrapper[]{DirectionWrapper.INCOMING, DirectionWrapper.BOTH};
    private static final DirectionWrapper[] DIRECTIONS_FOR_BOTH = new DirectionWrapper[]{DirectionWrapper.OUTGOING, DirectionWrapper.INCOMING, DirectionWrapper.BOTH};
    public static final RelIdArray EMPTY = new EmptyRelIdArray(-1);
    private final int type;
    private IdBlock outBlock;
    private IdBlock inBlock;
    public static final IdBlock EMPTY_BLOCK = new LowIdBlock();

    public static RelIdArray empty(int type) {
        return new EmptyRelIdArray(type);
    }

    public RelIdArray(int type) {
        this.type = type;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(8 + RelIdArray.sizeOfBlockWithReference(this.outBlock) + RelIdArray.sizeOfBlockWithReference(this.inBlock));
    }

    static int sizeOfBlockWithReference(IdBlock block) {
        return SizeOfs.withReference(block != null ? block.sizeOfObjectInBytesIncludingOverhead() : 0);
    }

    public int getType() {
        return this.type;
    }

    protected RelIdArray(RelIdArray from) {
        this(from.type);
        this.outBlock = from.outBlock;
        this.inBlock = from.inBlock;
    }

    protected RelIdArray(int type, IdBlock out, IdBlock in) {
        this(type);
        this.outBlock = out;
        this.inBlock = in;
    }

    public void add(long id, DirectionWrapper direction) {
        IdBlock block = direction.getBlock(this);
        if (block == null || !block.accepts(id)) {
            IdBlock newBlock = null;
            newBlock = block == null && LowIdBlock.idIsLow(id) ? new LowIdBlock() : (block != null ? block.upgradeToHighIdBlock() : new HighIdBlock());
            direction.setBlock(this, newBlock);
            block = newBlock;
        }
        block.add(id);
    }

    protected boolean accepts(RelIdArray source) {
        return source.getLastLoopBlock() == null;
    }

    public RelIdArray addAll(RelIdArray source) {
        if (!this.accepts(source)) {
            return this.upgradeIfNeeded(source).addAll(source);
        }
        this.appendFrom(source, DirectionWrapper.OUTGOING);
        this.appendFrom(source, DirectionWrapper.INCOMING);
        this.appendFrom(source, DirectionWrapper.BOTH);
        return this;
    }

    protected IdBlock getLastLoopBlock() {
        return null;
    }

    public RelIdArray shrink() {
        IdBlock shrunkOut = this.outBlock != null ? this.outBlock.shrink() : null;
        IdBlock shrunkIn = this.inBlock != null ? this.inBlock.shrink() : null;
        return shrunkOut == this.outBlock && shrunkIn == this.inBlock ? this : new RelIdArray(this.type, shrunkOut, shrunkIn);
    }

    protected void setLastLoopBlock(IdBlock block) {
        throw new UnsupportedOperationException("Should've upgraded to RelIdArrayWithLoops before this");
    }

    public RelIdArray upgradeIfNeeded(RelIdArray capabilitiesToMatch) {
        return capabilitiesToMatch.getLastLoopBlock() != null ? new RelIdArrayWithLoops(this) : this;
    }

    public RelIdArray downgradeIfPossible() {
        return this;
    }

    protected void appendFrom(RelIdArray source, DirectionWrapper direction) {
        IdBlock toBlock = direction.getBlock(this);
        IdBlock fromBlock = direction.getBlock(source);
        if (fromBlock == null) {
            return;
        }
        if (toBlock == null) {
            direction.setBlock(this, fromBlock.copyAndShrink());
        } else if (toBlock.accepts(fromBlock)) {
            toBlock.addAll(fromBlock);
        } else {
            toBlock = toBlock.upgradeToHighIdBlock();
            toBlock.addAll(fromBlock);
            direction.setBlock(this, toBlock);
        }
    }

    public boolean isEmpty() {
        return this.outBlock == null && this.inBlock == null && this.getLastLoopBlock() == null;
    }

    public RelIdIterator iterator(DirectionWrapper direction) {
        return direction.iterator(this);
    }

    protected RelIdArray newSimilarInstance() {
        return new RelIdArray(this.type);
    }

    public static DirectionWrapper wrap(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return DirectionWrapper.OUTGOING;
            }
            case INCOMING: {
                return DirectionWrapper.INCOMING;
            }
            case BOTH: {
                return DirectionWrapper.BOTH;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)direction));
    }

    public static RelIdArray from(RelIdArray src, RelIdArray add, Collection<Long> remove) {
        if (remove == null) {
            if (src == null) {
                return add.downgradeIfPossible();
            }
            if (add != null) {
                src = src.addAll(add);
                return src.downgradeIfPossible();
            }
            return src;
        }
        if (src == null && add == null) {
            return null;
        }
        RelIdArray newArray = null;
        if (src != null) {
            newArray = src.newSimilarInstance();
            newArray.addAll(src);
            RelIdArray.evictExcluded(newArray, remove);
        } else {
            newArray = add.newSimilarInstance();
        }
        if (add != null) {
            newArray = newArray.upgradeIfNeeded(add);
            RelIdIteratorImpl fromIterator = (RelIdIteratorImpl)add.iterator(DirectionWrapper.BOTH);
            while (fromIterator.hasNext()) {
                long value = fromIterator.next();
                if (remove.contains(value)) continue;
                newArray.add(value, fromIterator.currentDirection);
            }
        }
        return newArray;
    }

    private static void evictExcluded(RelIdArray ids, Collection<Long> excluded) {
        RelIdIteratorImpl iterator = (RelIdIteratorImpl)DirectionWrapper.BOTH.iterator(ids);
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (!excluded.contains(value)) continue;
            boolean swapSuccessful = false;
            IteratorState state = iterator.currentState;
            IdBlock block = state.block;
            for (int j = block.length() - 1; j >= state.relativePosition; --j) {
                long backValue = block.get(j);
                block.setLength(block.length() - 1);
                if (excluded.contains(backValue)) continue;
                block.set(backValue, state.relativePosition - 1);
                swapSuccessful = true;
                break;
            }
            if (swapSuccessful) continue;
            block.setLength(block.length() - 1);
        }
    }

    public boolean couldBeNeedingUpdate() {
        return this.outBlock != null && this.outBlock instanceof HighIdBlock || this.inBlock != null && this.inBlock instanceof HighIdBlock;
    }

    public static class RelIdIteratorImpl
    implements RelIdIterator {
        private final DirectionWrapper[] directions;
        private int directionPosition = -1;
        private DirectionWrapper currentDirection;
        private IteratorState currentState;
        private final IteratorState[] states;
        private long nextElement;
        private boolean nextElementDetermined;
        private RelIdArray ids;

        RelIdIteratorImpl(RelIdArray ids, DirectionWrapper[] directions) {
            this.ids = ids;
            this.directions = directions;
            this.states = new IteratorState[directions.length];
            IdBlock block = null;
            while (block == null && this.directionPosition + 1 < directions.length) {
                this.currentDirection = directions[++this.directionPosition];
                block = this.currentDirection.getBlock(ids);
            }
            if (block != null) {
                this.states[this.directionPosition] = this.currentState = new IteratorState(block, 0);
            }
        }

        @Override
        public int getType() {
            return this.ids.getType();
        }

        @Override
        public RelIdArray getIds() {
            return this.ids;
        }

        @Override
        public RelIdIterator updateSource(RelIdArray newSource, DirectionWrapper direction) {
            if (this.ids != newSource || newSource.couldBeNeedingUpdate()) {
                this.ids = newSource;
                for (int i = 0; i < this.states.length; ++i) {
                    if (this.states[i] == null) continue;
                    this.states[i].update(this.directions[i].getBlock(this.ids));
                }
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.nextElementDetermined) {
                return this.nextElement != -1L;
            }
            do {
                if (this.currentState == null || !this.currentState.hasNext()) continue;
                this.nextElement = this.currentState.next();
                this.nextElementDetermined = true;
                return true;
            } while (this.nextBlock());
            this.nextElementDetermined = false;
            this.nextElement = -1L;
            return false;
        }

        protected boolean nextBlock() {
            while (this.directionPosition + 1 < this.directions.length) {
                this.currentDirection = this.directions[++this.directionPosition];
                IteratorState nextState = this.states[this.directionPosition];
                if (nextState != null) {
                    this.currentState = nextState;
                    return true;
                }
                IdBlock block = this.currentDirection.getBlock(this.ids);
                if (block == null) continue;
                this.states[this.directionPosition] = this.currentState = new IteratorState(block, 0);
                return true;
            }
            return false;
        }

        @Override
        public void doAnotherRound() {
            this.directionPosition = -1;
            this.nextBlock();
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextElementDetermined = false;
            return this.nextElement;
        }
    }

    private static class IteratorState {
        private IdBlock block;
        private int relativePosition;

        public IteratorState(IdBlock block, int relativePosition) {
            this.block = block;
            this.relativePosition = relativePosition;
        }

        boolean hasNext() {
            return this.relativePosition < this.block.length();
        }

        long next() {
            long id = this.block.get(this.relativePosition++);
            return id;
        }

        public void update(IdBlock block) {
            this.block = block;
        }
    }

    private static class HighIdBlock
    extends IdBlock {
        private int[] ids;
        private byte[] highBits;

        public HighIdBlock() {
            this.ids = new int[3];
            this.highBits = new byte[3];
        }

        private HighIdBlock(LowIdBlock lowIdBlock) {
            this.ids = Arrays.copyOf(lowIdBlock.ids, lowIdBlock.ids.length);
            this.highBits = new byte[this.ids.length];
        }

        @Override
        public int sizeOfObjectInBytesIncludingOverhead() {
            return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.withArrayOverhead(4 * this.ids.length)) + SizeOfs.withReference(SizeOfs.withArrayOverhead(this.ids.length)));
        }

        @Override
        protected boolean accepts(long id) {
            return true;
        }

        @Override
        protected boolean accepts(IdBlock block) {
            return true;
        }

        @Override
        protected void append(IdBlock source, int targetStartIndex, int itemsToCopy) {
            if (source instanceof LowIdBlock) {
                System.arraycopy(((LowIdBlock)source).ids, 1, this.ids, targetStartIndex, itemsToCopy);
            } else {
                System.arraycopy(((HighIdBlock)source).ids, 1, this.ids, targetStartIndex, itemsToCopy);
                System.arraycopy(((HighIdBlock)source).highBits, 1, this.highBits, targetStartIndex, itemsToCopy);
            }
        }

        @Override
        IdBlock upgradeToHighIdBlock() {
            return this;
        }

        @Override
        protected IdBlock copyAndShrink() {
            HighIdBlock copy = new HighIdBlock();
            int itemsToCopy = this.length() + 1;
            copy.ids = Arrays.copyOf(this.ids, itemsToCopy);
            copy.highBits = Arrays.copyOf(this.highBits, itemsToCopy);
            return copy;
        }

        @Override
        protected void extendArrayTo(int numberOfItemsToCopy, int newLength) {
            int[] newIds = new int[newLength];
            byte[] newHighBits = new byte[newLength];
            System.arraycopy(this.ids, 0, newIds, 0, numberOfItemsToCopy + 1);
            System.arraycopy(this.highBits, 0, newHighBits, 0, numberOfItemsToCopy + 1);
            this.ids = newIds;
            this.highBits = newHighBits;
        }

        @Override
        protected int length() {
            return this.ids[0];
        }

        @Override
        protected int capacity() {
            return this.ids.length - 1;
        }

        @Override
        protected void setLength(int length) {
            this.ids[0] = length;
        }

        @Override
        protected long get(int index) {
            return (long)this.highBits[index + 1] << 32 | (long)this.ids[index + 1] & 0xFFFFFFFFL;
        }

        @Override
        protected void set(long id, int index) {
            this.ids[index + 1] = (int)id;
            this.highBits[index + 1] = (byte)((id & 0xFF00000000L) >>> 32);
        }
    }

    private static class LowIdBlock
    extends IdBlock {
        private int[] ids = new int[3];

        private LowIdBlock() {
        }

        @Override
        public int sizeOfObjectInBytesIncludingOverhead() {
            return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.withArrayOverhead(4 * this.ids.length)));
        }

        public static boolean idIsLow(long id) {
            return (id & 0xFF00000000L) == 0L;
        }

        @Override
        protected boolean accepts(long id) {
            return LowIdBlock.idIsLow(id);
        }

        @Override
        protected boolean accepts(IdBlock block) {
            return block instanceof LowIdBlock;
        }

        @Override
        protected void append(IdBlock source, int targetStartIndex, int itemsToCopy) {
            if (!(source instanceof LowIdBlock)) {
                throw new IllegalArgumentException(source.toString());
            }
            System.arraycopy(((LowIdBlock)source).ids, 1, this.ids, targetStartIndex, itemsToCopy);
        }

        @Override
        IdBlock upgradeToHighIdBlock() {
            return new HighIdBlock(this);
        }

        @Override
        protected IdBlock copyAndShrink() {
            LowIdBlock copy = new LowIdBlock();
            copy.ids = Arrays.copyOf(this.ids, this.length() + 1);
            return copy;
        }

        @Override
        protected void extendArrayTo(int numberOfItemsToCopy, int newLength) {
            int[] newIds = new int[newLength];
            System.arraycopy(this.ids, 0, newIds, 0, numberOfItemsToCopy + 1);
            this.ids = newIds;
        }

        @Override
        protected int length() {
            return this.ids[0];
        }

        @Override
        protected int capacity() {
            return this.ids.length - 1;
        }

        @Override
        protected void setLength(int length) {
            this.ids[0] = length;
        }

        @Override
        protected long get(int index) {
            assert (index >= 0 && index < this.length());
            return (long)this.ids[index + 1] & 0xFFFFFFFFL;
        }

        @Override
        protected void set(long id, int index) {
            this.ids[index + 1] = (int)id;
        }
    }

    public static abstract class IdBlock
    implements SizeOfObject {
        IdBlock shrink() {
            return this.length() == this.capacity() ? this : this.copyAndShrink();
        }

        void add(long id) {
            int length = this.ensureSpace(1);
            this.set(id, length);
            this.setLength(length + 1);
        }

        void addAll(IdBlock block) {
            int otherBlockLength = block.length();
            int length = this.ensureSpace(otherBlockLength + 1);
            this.append(block, length + 1, otherBlockLength);
            this.setLength(otherBlockLength + length);
        }

        int ensureSpace(int delta) {
            int capacity;
            int length = this.length();
            int newLength = length + delta;
            if (newLength >= (capacity = this.capacity())) {
                int calculatedLength = capacity * 2;
                if (newLength > calculatedLength) {
                    calculatedLength = newLength * 2;
                }
                this.extendArrayTo(length, calculatedLength);
            }
            return length;
        }

        protected abstract boolean accepts(long var1);

        protected abstract boolean accepts(IdBlock var1);

        protected abstract IdBlock copyAndShrink();

        abstract IdBlock upgradeToHighIdBlock();

        protected abstract void extendArrayTo(int var1, int var2);

        protected abstract void setLength(int var1);

        protected abstract int length();

        protected abstract int capacity();

        protected abstract void append(IdBlock var1, int var2, int var3);

        protected abstract long get(int var1);

        protected abstract void set(long var1, int var3);
    }

    public static enum DirectionWrapper {
        OUTGOING(Direction.OUTGOING){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIteratorImpl(ids, DIRECTIONS_FOR_OUTGOING);
            }

            @Override
            IdBlock getBlock(RelIdArray ids) {
                return ids.outBlock;
            }

            @Override
            void setBlock(RelIdArray ids, IdBlock block) {
                ids.outBlock = block;
            }
        }
        ,
        INCOMING(Direction.INCOMING){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIteratorImpl(ids, DIRECTIONS_FOR_INCOMING);
            }

            @Override
            IdBlock getBlock(RelIdArray ids) {
                return ids.inBlock;
            }

            @Override
            void setBlock(RelIdArray ids, IdBlock block) {
                ids.inBlock = block;
            }
        }
        ,
        BOTH(Direction.BOTH){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIteratorImpl(ids, DIRECTIONS_FOR_BOTH);
            }

            @Override
            IdBlock getBlock(RelIdArray ids) {
                return ids.getLastLoopBlock();
            }

            @Override
            void setBlock(RelIdArray ids, IdBlock block) {
                ids.setLastLoopBlock(block);
            }
        };

        private final Direction direction;

        private DirectionWrapper(Direction direction) {
            this.direction = direction;
        }

        abstract RelIdIterator iterator(RelIdArray var1);

        abstract IdBlock getBlock(RelIdArray var1);

        abstract void setBlock(RelIdArray var1, IdBlock var2);

        public Direction direction() {
            return this.direction;
        }
    }

    public static class EmptyRelIdArray
    extends RelIdArray {
        private static final DirectionWrapper[] EMPTY_DIRECTION_ARRAY = new DirectionWrapper[0];
        private final RelIdIterator EMPTY_ITERATOR = new RelIdIteratorImpl(this, EMPTY_DIRECTION_ARRAY){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            protected boolean nextBlock() {
                return false;
            }

            @Override
            public void doAnotherRound() {
            }

            @Override
            public RelIdIterator updateSource(RelIdArray newSource, DirectionWrapper direction) {
                return direction.iterator(newSource);
            }
        };

        private EmptyRelIdArray(int type) {
            super(type);
        }

        @Override
        public RelIdIterator iterator(DirectionWrapper direction) {
            return this.EMPTY_ITERATOR;
        }
    }
}

