/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.ArrayList;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.Title;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.GraphDatabaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.MonitorGc;

@Description(value="Settings for the Community edition of Neo4j")
public abstract class GraphDatabaseSettings {
    @Migrator
    private static final ConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
    @Title(value="Read only database")
    @Description(value="Only allow read operations from this Neo4j instance. This mode still requires write access to the directory for lock purposes")
    public static final GraphDatabaseSetting.BooleanSetting read_only = new GraphDatabaseSetting.BooleanSetting(Settings.setting("read_only", Settings.BOOLEAN, "false"));
    @Description(value="The type of cache to use for nodes and relationships. Note that the Neo4j Enterprise Edition has the additional 'gcr' cache type. See the chapter on caches in the manual for more information.")
    public static final CacheTypeSetting cache_type = new CacheTypeSetting(Settings.setting("cache_type", Settings.options(CacheTypeSetting.availableCaches()), CacheTypeSetting.availableCaches()[0]));
    @Description(value="Enable loading kernel extensions")
    public static final GraphDatabaseSetting.BooleanSetting load_kernel_extensions = new GraphDatabaseSetting.BooleanSetting(Settings.setting("load_kernel_extensions", Settings.BOOLEAN, "true"));
    @Description(value="Print out the effective Neo4j configuration after startup.")
    public static final GraphDatabaseSetting.BooleanSetting dump_configuration = new GraphDatabaseSetting.BooleanSetting(Settings.setting("dump_configuration", Settings.BOOLEAN, "false"));
    @Description(value="The name of the Transaction Manager service to use as defined in the TM service provider constructor.")
    public static final GraphDatabaseSetting.StringSetting tx_manager_impl = new GraphDatabaseSetting.StringSetting(Settings.setting("tx_manager_impl", Settings.STRING, "native", Settings.illegalValueMessage("Must be class name of TransactionManager implementation", Settings.matches(".+"))));
    @Description(value="Whether to allow a store upgrade in case the current version of the database starts against an older store version. Setting this to true does not guarantee successful upgrade, just that it allows an attempt at it.")
    public static final GraphDatabaseSetting.BooleanSetting allow_store_upgrade = new GraphDatabaseSetting.BooleanSetting(Settings.setting("allow_store_upgrade", Settings.BOOLEAN, "false"));
    @Description(value="Determines whether any TransactionInterceptors loaded will intercept externally received transactions (e.g. in HA) before they reach the logical log and are applied to the store.")
    public static final GraphDatabaseSetting.BooleanSetting intercept_deserialized_transactions = new GraphDatabaseSetting.BooleanSetting(Settings.setting("intercept_deserialized_transactions", Settings.BOOLEAN, "false"));
    @Description(value="Enable this to specify a parser other than the default one.")
    public static final GraphDatabaseSetting.OptionsSetting cypher_parser_version = new CypherParserSetting(Settings.setting("cypher_parser_version", Settings.options("1.7", "1.8", "1.9"), Settings.NO_DEFAULT));
    @Description(value="Used to set the number of Cypher query execution plans that are cached.")
    public static GraphDatabaseSetting<Integer> query_cache_size = new GraphDatabaseSetting.IntegerSetting(Settings.setting("query_cache_size", Settings.INTEGER, "100", Settings.min(0)));
    @Description(value="The directory where the database files are located.")
    public static final GraphDatabaseSetting.DirectorySetting store_dir = new GraphDatabaseSetting.DirectorySetting(Settings.setting("store_dir", Settings.PATH, Settings.NO_DEFAULT));
    @Description(value="The base name for the Neo4j Store files, either an absolute path or relative to the store_dir setting. This should generally not be changed.")
    public static final GraphDatabaseSetting.FileSetting neo_store = new GraphDatabaseSetting.FileSetting(Settings.setting("neo_store", Settings.PATH, "neostore", Settings.basePath(store_dir)));
    @Description(value="The base name for the logical log files, either an absolute path or relative to the store_dir setting. This should generally not be changed.")
    public static final GraphDatabaseSetting.FileSetting logical_log = new GraphDatabaseSetting.FileSetting(Settings.setting("logical_log", Settings.PATH, "nioneo_logical.log", Settings.basePath(store_dir)));
    @Description(value="Whether to enable logging to a remote server or not.")
    public static final GraphDatabaseSetting<Boolean> remote_logging_enabled = new GraphDatabaseSetting.BooleanSetting(Settings.setting("remote_logging_enabled", Settings.BOOLEAN, "false"));
    @Description(value="Host for remote logging using LogBack SocketAppender.")
    public static final GraphDatabaseSetting.StringSetting remote_logging_host = new GraphDatabaseSetting.StringSetting(Settings.setting("remote_logging_host", Settings.STRING, "127.0.0.1", Settings.illegalValueMessage("Must be a valid hostname", Settings.matches(".+"))));
    @Description(value="Port for remote logging using LogBack SocketAppender.")
    public static final GraphDatabaseSetting.PortSetting remote_logging_port = new GraphDatabaseSetting.PortSetting(Settings.setting("remote_logging_port", Settings.INTEGER, "4560", Settings.port));
    @Description(value="Threshold in bytes for when database logs (text logs, for debugging, that is) are rotated.")
    public static final GraphDatabaseSetting.IntegerSetting threshold_for_logging_rotation = new GraphDatabaseSetting.IntegerSetting(Settings.setting("logging.threshold_for_rotation", Settings.INTEGER, "104857600", Settings.min(1)));
    @Description(value="Controls the auto indexing feature for nodes. Setting to false shuts it down, while true enables it by default for properties listed in the node_keys_indexable setting.")
    public static final GraphDatabaseSetting.BooleanSetting node_auto_indexing = new GraphDatabaseSetting.BooleanSetting(Settings.setting("node_auto_indexing", Settings.BOOLEAN, "false"));
    @Description(value="A list of property names (comma separated) that will be indexed by default. This applies to Nodes only.")
    public static final GraphDatabaseSetting.StringSetting node_keys_indexable = new GraphDatabaseSetting.StringSetting(Settings.setting("node_keys_indexable", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("Must be a comma-separated list of keys to be indexed", Settings.matches(".+"))));
    @Description(value="Controls the auto indexing feature for relationships. Setting to false shuts it down, while true enables it by default for properties listed in the relationship_keys_indexable setting.")
    public static final GraphDatabaseSetting.BooleanSetting relationship_auto_indexing = new GraphDatabaseSetting.BooleanSetting(Settings.setting("relationship_auto_indexing", Settings.BOOLEAN, "false"));
    @Description(value=" A list of property names (comma separated) that will be indexed by default. This applies to Relationships only.")
    public static final GraphDatabaseSetting.StringSetting relationship_keys_indexable = new GraphDatabaseSetting.StringSetting(Settings.setting("relationship_keys_indexable", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("Must be a comma-separated list of keys to be indexed", Settings.matches(".+"))));
    @Description(value="Integer value that sets the maximum number of open lucene index searchers.")
    public static GraphDatabaseSetting.IntegerSetting lucene_searcher_cache_size = new GraphDatabaseSetting.IntegerSetting(Settings.setting("lucene_searcher_cache_size", Settings.INTEGER, Integer.toString(Integer.MAX_VALUE), Settings.min(1)));
    @Description(value="NOTE: This no longer has any effect. Integer value that sets the maximum number of open lucene index writers.")
    @Deprecated
    public static GraphDatabaseSetting.IntegerSetting lucene_writer_cache_size = new GraphDatabaseSetting.IntegerSetting(Settings.setting("lucene_writer_cache_size", Settings.INTEGER, Integer.toString(Integer.MAX_VALUE), Settings.min(1)));
    @Description(value="Determines whether any TransactionInterceptors loaded will intercept prepared transactions before they reach the logical log.")
    public static final GraphDatabaseSetting.BooleanSetting intercept_committing_transactions = new GraphDatabaseSetting.BooleanSetting(Settings.setting("intercept_committing_transactions", Settings.BOOLEAN, "false"));
    @Description(value="Make Neo4j keep the logical transaction logs for being able to backup the database.Can be used for specifying the threshold to prune logical logs after. For example \"10 days\" will prune logical logs that only contains transactions older than 10 days from the current time, or \"100k txs\" will keep the 100k latest transactions and prune any older transactions.")
    public static final GraphDatabaseSetting.StringSetting keep_logical_logs = new GraphDatabaseSetting.StringSetting(Settings.setting("keep_logical_logs", Settings.STRING, "true", Settings.illegalValueMessage("Must be 'true'/'false' or of format '<number><optional unit> <type>' for example '100M size' for limiting logical log space on disk to 100Mb, or '200k txs' for limiting the number of transactions to keep to 200 000.", Settings.matches(".+"))));
    @Description(value="Use a quick approach for rebuilding the ID generators. This give quicker recovery time, but will limit the ability to reuse the space of deleted entities.")
    public static final GraphDatabaseSetting.BooleanSetting rebuild_idgenerators_fast = new GraphDatabaseSetting.BooleanSetting(Settings.setting("rebuild_idgenerators_fast", Settings.BOOLEAN, "true"));
    @Description(value="Tell Neo4j to use memory mapped buffers for accessing the native storage layer.")
    public static final UseMemoryMappedBuffers use_memory_mapped_buffers = new UseMemoryMappedBuffers(Settings.setting("use_memory_mapped_buffers", Settings.BOOLEAN, Settings.NO_DEFAULT));
    @Description(value="Target size for pages of mapped memory.")
    public static final GraphDatabaseSetting<Long> mapped_memory_page_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("mapped_memory_page_size", Settings.BYTES, "1M"));
    @Description(value="The size to allocate for a memory mapping pool to be shared between all stores.")
    public static final GraphDatabaseSetting<Long> all_stores_total_mapped_memory_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("all_stores_total_mapped_memory_size", Settings.BYTES, "500M"));
    @Description(value="Tell Neo4j to regularly log memory mapping statistics.")
    public static final GraphDatabaseSetting<Boolean> log_mapped_memory_stats = new GraphDatabaseSetting.BooleanSetting(Settings.setting("log_mapped_memory_stats", Settings.BOOLEAN, "false"));
    @Description(value="The file where Neo4j will record memory mapping statistics.")
    public static final GraphDatabaseSetting.FileSetting log_mapped_memory_stats_filename = new GraphDatabaseSetting.FileSetting(Settings.setting("log_mapped_memory_stats_filename", Settings.PATH, "mapped_memory_stats.log", Settings.basePath(store_dir)));
    @Description(value="The number of records to be loaded between regular logging of memory mapping statistics.")
    public static final GraphDatabaseSetting<Integer> log_mapped_memory_stats_interval = new GraphDatabaseSetting.IntegerSetting(Settings.setting("log_mapped_memory_stats_interval", Settings.INTEGER, "1000000"));
    @Description(value="The size to allocate for memory mapping the node store.")
    public static final GraphDatabaseSetting<Long> nodestore_mapped_memory_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("neostore.nodestore.db.mapped_memory", Settings.BYTES, "20M"));
    @Description(value="The size to allocate for memory mapping the property value store.")
    public static final GraphDatabaseSetting<Long> nodestore_propertystore_mapped_memory_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("neostore.propertystore.db.mapped_memory", Settings.BYTES, "90M"));
    @Description(value="The size to allocate for memory mapping the store for property key indexes.")
    public static final GraphDatabaseSetting<Long> nodestore_propertystore_index_mapped_memory_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("neostore.propertystore.db.index.mapped_memory", Settings.BYTES, "1M"));
    @Description(value="The size to allocate for memory mapping the store for property key strings.")
    public static final GraphDatabaseSetting<Long> nodestore_propertystore_index_keys_mapped_memory_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("neostore.propertystore.db.index.keys.mapped_memory", Settings.BYTES, "1M"));
    @Description(value="The size to allocate for memory mapping the string property store.")
    public static final GraphDatabaseSetting<Long> strings_mapped_memory_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("neostore.propertystore.db.strings.mapped_memory", Settings.BYTES, "130M"));
    @Description(value="The size to allocate for memory mapping the array property store.")
    public static final GraphDatabaseSetting<Long> arrays_mapped_memory_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("neostore.propertystore.db.arrays.mapped_memory", Settings.BYTES, "130M"));
    @Description(value="The size to allocate for memory mapping the relationship store.")
    public static final GraphDatabaseSetting<Long> relationshipstore_mapped_memory_size = new GraphDatabaseSetting.NumberOfBytesSetting(Settings.setting("neostore.relationshipstore.db.mapped_memory", Settings.BYTES, "100M"));
    @Description(value="The size to allocate for memory mapping the node store.")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting nodestore_mapped_memory = new GraphDatabaseSetting.StringSetting(Settings.setting("neostore.nodestore.db.mapped_memory", Settings.STRING, "20M", Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="The size to allocate for memory mapping the property value store.")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_mapped_memory = new GraphDatabaseSetting.StringSetting(Settings.setting("neostore.propertystore.db.mapped_memory", Settings.STRING, "90M", Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="The size to allocate for memory mapping the store for property key indexes.")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_index_mapped_memory = new GraphDatabaseSetting.StringSetting(Settings.setting("neostore.propertystore.db.index.mapped_memory", Settings.STRING, "1M", Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="The size to allocate for memory mapping the store for property key strings.")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_index_keys_mapped_memory = new GraphDatabaseSetting.StringSetting(Settings.setting("neostore.propertystore.db.index.keys.mapped_memory", Settings.STRING, "1M", Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="The size to allocate for memory mapping the string property store.")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting strings_mapped_memory = new GraphDatabaseSetting.StringSetting(Settings.setting("neostore.propertystore.db.strings.mapped_memory", Settings.STRING, "130M", Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="The size to allocate for memory mapping the array property store.")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting arrays_mapped_memory = new GraphDatabaseSetting.StringSetting(Settings.setting("neostore.propertystore.db.arrays.mapped_memory", Settings.STRING, "130M", Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="The size to allocate for memory mapping the relationship store.")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting relationshipstore_mapped_memory = new GraphDatabaseSetting.StringSetting(Settings.setting("neostore.relationshipstore.db.mapped_memory", Settings.STRING, "100M", Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="How many relationships to read at a time during iteration")
    public static final GraphDatabaseSetting.IntegerSetting relationship_grab_size = new GraphDatabaseSetting.IntegerSetting(Settings.setting("relationship_grab_size", Settings.INTEGER, "100", Settings.min(1)));
    @Description(value="Whether to grab locks on files or not.")
    @Deprecated
    public static final GraphDatabaseSetting.BooleanSetting grab_file_lock = new GraphDatabaseSetting.BooleanSetting(Settings.setting("grab_file_lock", Settings.BOOLEAN, "true"));
    @Description(value="Specifies the block size for storing strings. This parameter is only honored when the store is created, otherwise it is ignored. Note that each character in a string occupies two bytes, meaning that a block size of 120 (the default size) will hold a 60 character long string before overflowing into a second block. Also note that each block carries an overhead of 8 bytes. This means that if the block size is 120, the size of the stored records will be 128 bytes.")
    public static final GraphDatabaseSetting.IntegerSetting string_block_size = new GraphDatabaseSetting.IntegerSetting(Settings.setting("string_block_size", Settings.INTEGER, "120", Settings.min(1)));
    @Description(value="Specifies the block size for storing arrays. This parameter is only honored when the store is created, otherwise it is ignored. The default block size is 120 bytes, and the overhead of each block is the same as for string blocks, i.e., 8 bytes.")
    public static final GraphDatabaseSetting.IntegerSetting array_block_size = new GraphDatabaseSetting.IntegerSetting(Settings.setting("array_block_size", Settings.INTEGER, "120", Settings.min(1)));
    @Description(value="Mark this database as a backup slave.")
    public static final GraphDatabaseSetting.BooleanSetting backup_slave = new GraphDatabaseSetting.BooleanSetting(Settings.setting("backup_slave", Settings.BOOLEAN, "false"));
    @Description(value="An identifier that uniquely identifies this graph database instance within this JVM. Defaults to an auto-generated number depending on how many instance are started in this JVM.")
    public static final GraphDatabaseSetting<String> forced_kernel_id = new GraphDatabaseSetting.StringSetting(Settings.setting("forced_kernel_id", Settings.STRING, Settings.NO_DEFAULT, Settings.illegalValueMessage("invalid kernel identifier", Settings.matches("[a-zA-Z0-9]*"))));
    public static final GraphDatabaseSetting.BooleanSetting execution_guard_enabled = new GraphDatabaseSetting.BooleanSetting(Settings.setting("execution_guard_enabled", Settings.BOOLEAN, "false"));
    @Description(value="Amount of time in ms the GC monitor thread will wait before taking another measurement.")
    public static final GraphDatabaseSetting<Long> gc_monitor_interval = MonitorGc.Configuration.gc_monitor_wait_time;
    @Description(value="The amount of time in ms the monitor thread has to be blocked before logging a message it was blocked.")
    public static final GraphDatabaseSetting<Long> gc_monitor_block_threshold = MonitorGc.Configuration.gc_monitor_threshold;
    @Description(value="Amount of time in ms the GC monitor thread will wait before taking another measurement.")
    @Deprecated
    public static GraphDatabaseSetting.StringSetting gc_monitor_wait_time = new GraphDatabaseSetting.StringSetting(Settings.setting("gc_monitor_wait_time", Settings.STRING, "100ms", Settings.matches("\\d+(ms|s|m)")));
    @Description(value="The amount of time in ms the monitor thread has to be blocked before logging a message it was blocked.")
    @Deprecated
    public static GraphDatabaseSetting.StringSetting gc_monitor_threshold = new GraphDatabaseSetting.StringSetting(Settings.setting("gc_monitor_threshold", Settings.STRING, "200ms", Settings.matches("\\d+(ms|s|m)")));
    @Description(value="The amount of memory to use for the node cache (when using the 'gcr' cache).")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting node_cache_size = new GraphDatabaseSetting.StringSetting(Settings.setting("node_cache_size", Settings.STRING, Settings.NO_DEFAULT, Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="The amount of memory to use for the relationship cache (when using the 'gcr' cache).")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting relationship_cache_size = new GraphDatabaseSetting.StringSetting(Settings.setting("relationship_cache_size", Settings.STRING, Settings.NO_DEFAULT, Settings.matches("\\d+[kmgKMG]?")));
    @Description(value="The fraction of the heap (1%-10%) to use for the base array in the node cache (when using the 'gcr' cache).")
    @Deprecated
    public static final GraphDatabaseSetting.FloatSetting node_cache_array_fraction = new GraphDatabaseSetting.FloatSetting(Settings.setting("node_cache_array_fraction", Settings.FLOAT, "1.0", Settings.range(Float.valueOf(1.0f), Float.valueOf(10.0f))));
    @Description(value="The fraction of the heap (1%-10%) to use for the base array in the relationship cache (when using the 'gcr' cache).")
    @Deprecated
    public static final GraphDatabaseSetting.FloatSetting relationship_cache_array_fraction = new GraphDatabaseSetting.FloatSetting(Settings.setting("relationship_cache_array_fraction", Settings.FLOAT, "1.0", Settings.range(Float.valueOf(1.0f), Float.valueOf(10.0f))));
    @Description(value="The minimal time that must pass in between logging statistics from the cache (when using the 'gcr' cache).")
    @Deprecated
    public static final GraphDatabaseSetting.StringSetting gcr_cache_min_log_interval = new GraphDatabaseSetting.StringSetting(Settings.setting("gcr_cache_min_log_interval", Settings.STRING, "60s", Settings.matches("\\d+(ms|s|m)")));

    public static class UseMemoryMappedBuffers
    extends GraphDatabaseSetting.BooleanSetting {
        public UseMemoryMappedBuffers(Setting<Boolean> setting) {
            super(setting);
        }

        public static boolean shouldMemoryMap(Boolean useMemoryMapped) {
            if (useMemoryMapped != null) {
                return useMemoryMapped;
            }
            return !UseMemoryMappedBuffers.osIsWindows();
        }
    }

    public static class CypherParserSetting
    extends GraphDatabaseSetting.OptionsSetting {
        @Description(value="Cypher v1.7 syntax.")
        public static final String v1_7 = "1.7";
        @Description(value="Cypher v1.8 syntax.")
        public static final String v1_8 = "1.8";
        @Description(value="Cypher v1.9 syntax.")
        public static final String v1_9 = "1.9";

        public CypherParserSetting(Setting<String> setting) {
            super(setting);
        }
    }

    public static class CacheTypeSetting
    extends GraphDatabaseSetting.SettingWrapper<String> {
        @Description(value="Use weak reference cache.")
        public static final String weak = "weak";
        @Description(value="Provides optimal utilization of the available memory. Suitable for high performance traversal. \nMay run into GC issues under high load if the frequently accessed parts of the graph does not fit in the cache.")
        public static final String soft = "soft";
        @Description(value="Don't use caching.")
        public static final String none = "none";
        @Description(value="Use strong references.")
        public static final String strong = "strong";
        @Description(value="GC resistant cache. Gets assigned a configurable amount of space in the JVM heap \nand will evict objects whenever it grows bigger than that, instead of relying on GC for eviction. \nIt has got the fastest insert/lookup times and should be optimal for most use cases. \nThis is the default cache setting.")
        public static final String gcr = "gcr";

        public CacheTypeSetting(Setting<String> setting) {
            super(setting);
        }

        public static String[] availableCaches() {
            ArrayList<String> available = new ArrayList<String>();
            for (CacheProvider cacheProvider : Service.load(CacheProvider.class)) {
                available.add(cacheProvider.getName());
            }
            for (String prioritized : new String[]{soft, gcr}) {
                if (!available.remove(prioritized)) continue;
                available.add(0, prioritized);
            }
            return available.toArray(new String[0]);
        }
    }
}

