/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;

public class LegacyPropertyIndexStoreReader {
    public static final String FROM_VERSION = "PropertyIndex v0.9.9";
    private final File fileName;
    private final FileSystemAbstraction fs;

    public LegacyPropertyIndexStoreReader(FileSystemAbstraction fs, File fileName) {
        this.fs = fs;
        this.fileName = fileName;
    }

    public Iterable<PropertyIndexRecord> readPropertyIndexStore() throws IOException {
        FileChannel fileChannel = this.fs.open(this.fileName, "r");
        int recordLength = 9;
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        long recordCount = (fileChannel.size() - (long)endHeaderSize) / (long)recordLength;
        LinkedList<PropertyIndexRecord> records = new LinkedList<PropertyIndexRecord>();
        ByteBuffer buffer = ByteBuffer.allocateDirect(recordLength);
        int id = 0;
        while ((long)id <= recordCount) {
            boolean inUse;
            buffer.position(0);
            fileChannel.read(buffer);
            buffer.flip();
            long inUseByte = buffer.get();
            boolean bl = inUse = inUseByte == (long)Record.IN_USE.byteValue();
            if (inUse) {
                PropertyIndexRecord record = new PropertyIndexRecord(id);
                record.setInUse(inUse);
                record.setPropertyCount(buffer.getInt());
                record.setNameId(buffer.getInt());
                records.add(record);
            }
            ++id;
        }
        fileChannel.close();
        return records;
    }
}

