/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;

public abstract class StringLogger {
    public static final String DEFAULT_NAME = "messages.log";
    public static final StringLogger SYSTEM = new ActualStringLogger(new PrintWriter(System.out));
    private static final int DEFAULT_THRESHOLD_FOR_ROTATION = 0x6400000;
    private static final int NUMBER_OF_OLD_LOGS_TO_KEEP = 2;
    public static final StringLogger DEV_NULL = new StringLogger(){

        @Override
        public void logMessage(String msg, boolean flush) {
        }

        @Override
        public void logMessage(String msg, Throwable cause, boolean flush) {
        }

        @Override
        public void logLongMessage(String msg, Visitor<LineLogger> source, boolean flush) {
        }

        @Override
        protected void logLine(String line) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void addRotationListener(Runnable listener) {
        }
    };

    public static StringLogger logger(File logfile) {
        try {
            return new ActualStringLogger(new PrintWriter(new FileWriter(logfile, true)));
        }
        catch (IOException cause) {
            throw new RuntimeException("Could not create log file: " + logfile, cause);
        }
    }

    public static StringLogger logger(String storeDir) {
        return StringLogger.logger(storeDir, 0x6400000);
    }

    public static StringLogger logger(String storeDir, int rotationThreshold) {
        return new ActualStringLogger(new File(storeDir, DEFAULT_NAME).getAbsolutePath(), rotationThreshold);
    }

    public static StringLogger wrap(final StringBuffer target) {
        return new ActualStringLogger(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                target.append(cbuf, off, len);
            }

            @Override
            public void write(int c) throws IOException {
                target.appendCodePoint(c);
            }

            @Override
            public void write(char[] cbuf) throws IOException {
                target.append(cbuf);
            }

            @Override
            public void write(String str) throws IOException {
                target.append(str);
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                target.append(str, off, len);
            }

            @Override
            public Writer append(char c) throws IOException {
                target.append(c);
                return this;
            }

            @Override
            public Writer append(CharSequence csq) throws IOException {
                target.append(csq);
                return this;
            }

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                target.append(csq, start, end);
                return this;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }));
    }

    public void logMessage(String msg) {
        this.logMessage(msg, false);
    }

    public void logMessage(String msg, Throwable cause) {
        this.logMessage(msg, cause, false);
    }

    public void logLongMessage(String msg, Visitor<LineLogger> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, Iterable<String> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, Iterable<String> source, boolean flush) {
        this.logLongMessage(msg, source.iterator(), flush);
    }

    public void logLongMessage(String msg, Iterator<String> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, final Iterator<String> source, boolean flush) {
        this.logLongMessage(msg, new Visitor<LineLogger>(){

            @Override
            public boolean visit(LineLogger logger) {
                for (String line : IteratorUtil.loop(source)) {
                    logger.logLine(line);
                }
                return true;
            }
        }, flush);
    }

    public abstract void logLongMessage(String var1, Visitor<LineLogger> var2, boolean var3);

    public abstract void logMessage(String var1, boolean var2);

    public abstract void logMessage(String var1, Throwable var2, boolean var3);

    public abstract void addRotationListener(Runnable var1);

    public abstract void flush();

    public abstract void close();

    protected abstract void logLine(String var1);

    protected static final class LineLoggerImpl
    implements LineLogger {
        private final StringLogger target;

        public LineLoggerImpl(StringLogger target) {
            this.target = target;
        }

        @Override
        public void logLine(String line) {
            this.target.logLine(line);
        }
    }

    private static class ActualStringLogger
    extends StringLogger {
        private PrintWriter out;
        private final Integer rotationThreshold;
        private final File file;
        private final List<Runnable> onRotation = new CopyOnWriteArrayList<Runnable>();
        private volatile boolean doingRotation = false;

        private ActualStringLogger(String filename, int rotationThreshold) {
            this.rotationThreshold = rotationThreshold;
            try {
                this.file = new File(filename);
                if (this.file.getParentFile() != null) {
                    this.file.getParentFile().mkdirs();
                }
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ActualStringLogger(PrintWriter writer) {
            this.out = writer;
            this.rotationThreshold = null;
            this.file = null;
        }

        @Override
        public void addRotationListener(Runnable trigger) {
            this.onRotation.add(trigger);
        }

        private void instantiateWriter() throws IOException {
            this.out = new PrintWriter(new FileWriter(this.file, true));
            for (Runnable trigger : this.onRotation) {
                trigger.run();
            }
        }

        @Override
        public synchronized void logMessage(String msg, boolean flush) {
            this.out.println(this.time() + ": " + msg);
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        private String time() {
            return Format.date();
        }

        @Override
        public synchronized void logMessage(String msg, Throwable cause, boolean flush) {
            this.out.println(this.time() + ": " + msg + " " + cause.getMessage());
            cause.printStackTrace(this.out);
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        @Override
        public synchronized void logLongMessage(String msg, Visitor<LineLogger> source, boolean flush) {
            this.out.println(this.time() + ": " + msg);
            source.visit(new LineLoggerImpl(this));
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        @Override
        protected void logLine(String line) {
            this.out.println("    " + line);
        }

        private void checkRotation() {
            if (this.rotationThreshold != null && this.file.length() > (long)this.rotationThreshold.intValue() && !this.doingRotation) {
                this.doRotation();
            }
        }

        private void doRotation() {
            this.doingRotation = true;
            this.out.close();
            this.moveAwayFile();
            try {
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.doingRotation = false;
            }
        }

        private void moveAwayFile() {
            File oldLogFile = new File(this.file.getParentFile(), this.file.getName() + "." + 2);
            if (oldLogFile.exists()) {
                oldLogFile.delete();
            }
            for (int i = 1; i >= 0; --i) {
                oldLogFile = new File(this.file.getParentFile(), this.file.getName() + (i == 0 ? "" : "." + i));
                if (!oldLogFile.exists()) continue;
                oldLogFile.renameTo(new File(this.file.getParentFile(), this.file.getName() + "." + (i + 1)));
            }
        }

        @Override
        public void flush() {
            this.out.flush();
        }

        @Override
        public void close() {
            this.out.close();
        }

        public String toString() {
            return "StringLogger[" + this.file + "]";
        }
    }

    public static interface LineLogger {
        public void logLine(String var1);
    }
}

