/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LongerShortString;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.ShortArray;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.util.StringLogger;

public class PropertyStore
extends AbstractStore
implements Store,
RecordStore<PropertyRecord> {
    public static final int DEFAULT_DATA_BLOCK_SIZE = 120;
    public static final int DEFAULT_PAYLOAD_SIZE = 32;
    public static final String TYPE_DESCRIPTOR = "PropertyStore";
    public static final int RECORD_SIZE = 41;
    private DynamicStringStore stringPropertyStore;
    private PropertyIndexStore propertyIndexStore;
    private DynamicArrayStore arrayPropertyStore;

    public PropertyStore(String fileName, Config configuration, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore stringPropertyStore, PropertyIndexStore propertyIndexStore, DynamicArrayStore arrayPropertyStore) {
        super(fileName, configuration, IdType.PROPERTY, idGeneratorFactory, fileSystemAbstraction, stringLogger);
        this.stringPropertyStore = stringPropertyStore;
        this.propertyIndexStore = propertyIndexStore;
        this.arrayPropertyStore = arrayPropertyStore;
    }

    @Override
    public void accept(RecordStore.Processor processor, PropertyRecord record) {
        processor.processProperty(this, record);
    }

    DynamicStringStore getStringStore() {
        return this.stringPropertyStore;
    }

    DynamicArrayStore getArrayStore() {
        return this.arrayPropertyStore;
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
        this.stringPropertyStore.setRecovered();
        this.propertyIndexStore.setRecovered();
        this.arrayPropertyStore.setRecovered();
    }

    @Override
    protected void unsetRecovered() {
        super.unsetRecovered();
        this.stringPropertyStore.unsetRecovered();
        this.propertyIndexStore.unsetRecovered();
        this.arrayPropertyStore.unsetRecovered();
    }

    @Override
    protected void closeStorage() {
        if (this.stringPropertyStore != null) {
            this.stringPropertyStore.close();
            this.stringPropertyStore = null;
        }
        if (this.propertyIndexStore != null) {
            this.propertyIndexStore.close();
            this.propertyIndexStore = null;
        }
        if (this.arrayPropertyStore != null) {
            this.arrayPropertyStore.close();
            this.arrayPropertyStore = null;
        }
    }

    @Override
    public void flushAll() {
        this.stringPropertyStore.flushAll();
        this.propertyIndexStore.flushAll();
        this.arrayPropertyStore.flushAll();
        super.flushAll();
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 41;
    }

    @Override
    public int getRecordHeaderSize() {
        return 9;
    }

    private long nextStringBlockId() {
        return this.stringPropertyStore.nextBlockId();
    }

    public void freeStringBlockId(long blockId) {
        this.stringPropertyStore.freeBlockId(blockId);
    }

    private long nextArrayBlockId() {
        return this.arrayPropertyStore.nextBlockId();
    }

    public void freeArrayBlockId(long blockId) {
        this.arrayPropertyStore.freeBlockId(blockId);
    }

    public PropertyIndexStore getIndexStore() {
        return this.propertyIndexStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(PropertyRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(PropertyRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public void forceUpdateRecord(PropertyRecord record) {
        this.updateRecord(record);
    }

    private void updateRecord(PropertyRecord record, PersistenceWindow window) {
        long id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            short prevModifier = record.getPrevProp() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((record.getPrevProp() & 0xF00000000L) >> 28);
            short nextModifier = record.getNextProp() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((record.getNextProp() & 0xF00000000L) >> 32);
            byte modifiers = (byte)(prevModifier | nextModifier);
            buffer.put(modifiers);
            buffer.putInt((int)record.getPrevProp()).putInt((int)record.getNextProp());
            int longsAppended = 0;
            for (PropertyBlock block : record.getPropertyBlocks()) {
                long[] propBlockValues = block.getValueBlocks();
                for (int k = 0; k < propBlockValues.length; ++k) {
                    buffer.putLong(propBlockValues[k]);
                }
                longsAppended += propBlockValues.length;
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.updateDynamicRecords(block.getValueRecords());
            }
            if (longsAppended < PropertyType.getPayloadSizeLongs()) {
                buffer.putLong(0L);
            }
        } else {
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
            buffer.setOffset(buffer.getOffset() + 9);
            buffer.putLong(0L);
        }
        this.updateDynamicRecords(record.getDeletedRecords());
    }

    private void updateDynamicRecords(List<DynamicRecord> records) {
        for (DynamicRecord valueRecord : records) {
            if (valueRecord.getType() == PropertyType.STRING.intValue()) {
                this.stringPropertyStore.updateRecord(valueRecord);
                continue;
            }
            if (valueRecord.getType() == PropertyType.ARRAY.intValue()) {
                this.arrayPropertyStore.updateRecord(valueRecord);
                continue;
            }
            throw new InvalidRecordException("Unknown dynamic record" + valueRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyRecord getLightRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            PropertyRecord record;
            PropertyRecord propertyRecord = record = this.getRecord(id, window, RecordLoad.NORMAL);
            return propertyRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public void makeHeavy(PropertyBlock record) {
        block3: {
            block2: {
                if (record.getType() != PropertyType.STRING) break block2;
                Collection<DynamicRecord> stringRecords = this.stringPropertyStore.getLightRecords(record.getSingleValueLong());
                for (DynamicRecord stringRecord : stringRecords) {
                    stringRecord.setType(PropertyType.STRING.intValue());
                    record.addValueRecord(stringRecord);
                }
                break block3;
            }
            if (record.getType() != PropertyType.ARRAY) break block3;
            Collection<DynamicRecord> arrayRecords = this.arrayPropertyStore.getLightRecords(record.getSingleValueLong());
            for (DynamicRecord arrayRecord : arrayRecords) {
                arrayRecord.setType(PropertyType.ARRAY.intValue());
                record.addValueRecord(arrayRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyRecord getRecord(long id) {
        PropertyRecord record;
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            record = this.getRecord(id, window, RecordLoad.NORMAL);
        }
        finally {
            this.releaseWindow(window);
        }
        for (PropertyBlock block : record.getPropertyBlocks()) {
            if (block.getType() == PropertyType.STRING) {
                Collection<DynamicRecord> stringRecords = this.stringPropertyStore.getLightRecords(block.getSingleValueLong());
                for (DynamicRecord stringRecord : stringRecords) {
                    stringRecord.setType(PropertyType.STRING.intValue());
                    block.addValueRecord(stringRecord);
                }
                continue;
            }
            if (block.getType() != PropertyType.ARRAY) continue;
            Collection<DynamicRecord> arrayRecords = this.arrayPropertyStore.getLightRecords(block.getSingleValueLong());
            for (DynamicRecord arrayRecord : arrayRecords) {
                arrayRecord.setType(PropertyType.ARRAY.intValue());
                block.addValueRecord(arrayRecord);
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyRecord forceGetRecord(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return new PropertyRecord(id);
        }
        try {
            PropertyRecord propertyRecord = this.getRecord(id, window, RecordLoad.FORCE);
            return propertyRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public PropertyRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    private PropertyRecord getRecordFromBuffer(long id, Buffer buffer) {
        PropertyBlock newBlock;
        int offsetAtBeggining = buffer.getOffset();
        PropertyRecord record = new PropertyRecord(id);
        byte modifiers = buffer.get();
        long prevMod = ((long)modifiers & 0xF0L) << 28;
        long nextMod = ((long)modifiers & 0xFL) << 32;
        long prevProp = buffer.getUnsignedInt();
        long nextProp = buffer.getUnsignedInt();
        record.setPrevProp(this.longFromIntAndMod(prevProp, prevMod));
        record.setNextProp(this.longFromIntAndMod(nextProp, nextMod));
        while (buffer.getOffset() - offsetAtBeggining < 41 && (newBlock = this.getPropertyBlock(buffer)) != null) {
            record.addPropertyBlock(newBlock);
            record.setInUse(true);
        }
        return record;
    }

    private PropertyRecord getRecord(long id, PersistenceWindow window, RecordLoad load) {
        Buffer buffer = window.getOffsettedBuffer(id);
        PropertyRecord toReturn = this.getRecordFromBuffer(id, buffer);
        if (!toReturn.inUse() && load != RecordLoad.FORCE) {
            throw new InvalidRecordException("PropertyRecord[" + id + "] not in use");
        }
        return toReturn;
    }

    private PropertyBlock getPropertyBlock(Buffer buffer) {
        long header = buffer.getLong();
        PropertyType type = PropertyType.getPropertyType(header, true);
        if (type == null) {
            return null;
        }
        PropertyBlock toReturn = new PropertyBlock();
        int numBlocks = type.calculateNumberOfBlocksUsed(header);
        long[] blockData = new long[numBlocks];
        blockData[0] = header;
        for (int i = 1; i < numBlocks; ++i) {
            blockData[i] = buffer.getLong();
        }
        toReturn.setValueBlocks(blockData);
        return toReturn;
    }

    public Object getValue(PropertyBlock propertyBlock) {
        return propertyBlock.getType().getValue(propertyBlock, this);
    }

    @Override
    public void makeStoreOk() {
        this.propertyIndexStore.makeStoreOk();
        this.stringPropertyStore.makeStoreOk();
        this.arrayPropertyStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.propertyIndexStore.rebuildIdGenerators();
        this.stringPropertyStore.rebuildIdGenerators();
        this.arrayPropertyStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.propertyIndexStore.updateIdGenerators();
        this.stringPropertyStore.updateHighId();
        this.arrayPropertyStore.updateHighId();
        this.updateHighId();
    }

    private Collection<DynamicRecord> allocateStringRecords(long valueBlockId, byte[] chars) {
        return this.stringPropertyStore.allocateRecords(valueBlockId, chars);
    }

    private Collection<DynamicRecord> allocateArrayRecords(long valueBlockId, Object array) {
        return this.arrayPropertyStore.allocateRecords(valueBlockId, array);
    }

    public void encodeValue(PropertyBlock block, int keyId, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (LongerShortString.encode(keyId, string, block, PropertyType.getPayloadSize())) {
                return;
            }
            long stringBlockId = this.nextStringBlockId();
            this.setSingleBlockValue(block, keyId, PropertyType.STRING, stringBlockId);
            byte[] encodedString = PropertyStore.encodeString(string);
            Collection<DynamicRecord> valueRecords = this.allocateStringRecords(stringBlockId, encodedString);
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
                block.addValueRecord(valueRecord);
            }
        } else if (value instanceof Integer) {
            this.setSingleBlockValue(block, keyId, PropertyType.INT, ((Integer)value).longValue());
        } else if (value instanceof Boolean) {
            this.setSingleBlockValue(block, keyId, PropertyType.BOOL, (Boolean)value != false ? 1L : 0L);
        } else if (value instanceof Float) {
            this.setSingleBlockValue(block, keyId, PropertyType.FLOAT, Float.floatToRawIntBits(((Float)value).floatValue()));
        } else if (value instanceof Long) {
            long keyAndType = (long)keyId | (long)PropertyType.LONG.intValue() << 24;
            if (ShortArray.LONG.getRequiredBits((Long)value) <= 35) {
                block.setSingleBlock(keyAndType | 0x10000000L | (Long)value << 29);
            } else {
                block.setValueBlocks(new long[]{keyAndType, (Long)value});
            }
        } else if (value instanceof Double) {
            block.setValueBlocks(new long[]{(long)keyId | (long)PropertyType.DOUBLE.intValue() << 24, Double.doubleToRawLongBits((Double)value)});
        } else if (value instanceof Byte) {
            this.setSingleBlockValue(block, keyId, PropertyType.BYTE, ((Byte)value).longValue());
        } else if (value instanceof Character) {
            this.setSingleBlockValue(block, keyId, PropertyType.CHAR, ((Character)value).charValue());
        } else if (value instanceof Short) {
            this.setSingleBlockValue(block, keyId, PropertyType.SHORT, ((Short)value).longValue());
        } else if (value.getClass().isArray()) {
            if (ShortArray.encode(keyId, value, block, PropertyType.getPayloadSize())) {
                return;
            }
            long arrayBlockId = this.nextArrayBlockId();
            this.setSingleBlockValue(block, keyId, PropertyType.ARRAY, arrayBlockId);
            Collection<DynamicRecord> arrayRecords = this.allocateArrayRecords(arrayBlockId, value);
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
                block.addValueRecord(valueRecord);
            }
        } else {
            throw new IllegalArgumentException("Unknown property type on: " + value + ", " + value.getClass());
        }
    }

    private void setSingleBlockValue(PropertyBlock block, int keyId, PropertyType type, long longValue) {
        block.setSingleBlock((long)keyId | (long)type.intValue() << 24 | longValue << 28);
    }

    public static byte[] encodeString(String string) {
        return UTF8.encode(string);
    }

    public Object getStringFor(PropertyBlock propertyBlock) {
        return PropertyStore.getStringFor(this.stringPropertyStore, propertyBlock);
    }

    public static Object getStringFor(AbstractDynamicStore store, PropertyBlock propertyBlock) {
        return PropertyStore.getStringFor(store, propertyBlock.getSingleValueLong(), propertyBlock.getValueRecords());
    }

    public static Object getStringFor(AbstractDynamicStore store, long startRecord, Collection<DynamicRecord> dynamicRecords) {
        Pair<byte[], byte[]> source = PropertyStore.readFullByteArray(startRecord, dynamicRecords, store, PropertyType.STRING);
        return PropertyStore.getStringFor(source.other());
    }

    public static Object getStringFor(byte[] byteArray) {
        return UTF8.decode(byteArray);
    }

    public Object getArrayFor(PropertyBlock propertyBlock) {
        assert (!propertyBlock.isLight());
        return PropertyStore.getArrayFor(propertyBlock.getSingleValueLong(), propertyBlock.getValueRecords(), this.arrayPropertyStore);
    }

    public static Object getArrayFor(long startRecord, Iterable<DynamicRecord> records, DynamicArrayStore arrayPropertyStore) {
        return arrayPropertyStore.getRightArray(PropertyStore.readFullByteArray(startRecord, records, arrayPropertyStore, PropertyType.ARRAY));
    }

    public static Pair<byte[], byte[]> readFullByteArray(long startRecord, Iterable<DynamicRecord> records, AbstractDynamicStore store, PropertyType propertyType) {
        long recordToFind = startRecord;
        HashMap<Long, DynamicRecord> recordsMap = new HashMap<Long, DynamicRecord>();
        for (DynamicRecord record : records) {
            recordsMap.put(record.getId(), record);
        }
        byte[] header = null;
        LinkedList<byte[]> byteList = new LinkedList<byte[]>();
        int totalSize = 0;
        while (recordToFind != (long)Record.NO_NEXT_BLOCK.intValue()) {
            DynamicRecord record = (DynamicRecord)recordsMap.get(recordToFind);
            if (record.isLight()) {
                store.makeHeavy(record);
            }
            int offset = 0;
            if (recordToFind == startRecord) {
                header = propertyType.readDynamicRecordHeader(record.getData());
                offset = header.length;
            }
            byteList.add(record.getData());
            totalSize += record.getData().length - offset;
            recordToFind = record.getNextBlock();
        }
        byte[] bArray = new byte[totalSize];
        int sourceOffset = header.length;
        int offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, sourceOffset, bArray, offset, currentArray.length - sourceOffset);
            offset += currentArray.length - sourceOffset;
            sourceOffset = 0;
        }
        return Pair.of(header, bArray);
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.stringPropertyStore.getWindowPoolStats());
        list.add(this.arrayPropertyStore.getWindowPoolStats());
        list.add(this.getWindowPoolStats());
        return list;
    }

    @Override
    public void logAllWindowPoolStats(StringLogger.LineLogger logger) {
        super.logAllWindowPoolStats(logger);
        this.propertyIndexStore.logAllWindowPoolStats(logger);
        logger.logLine(this.stringPropertyStore.getWindowPoolStats().toString());
        logger.logLine(this.arrayPropertyStore.getWindowPoolStats().toString());
    }

    public int getStringBlockSize() {
        return this.stringPropertyStore.getBlockSize();
    }

    public int getArrayBlockSize() {
        return this.arrayPropertyStore.getBlockSize();
    }

    @Override
    protected boolean isRecordInUse(ByteBuffer buffer) {
        Buffer fromByteBuffer = new Buffer(null, buffer);
        return buffer.limit() >= 41 && this.getRecordFromBuffer(0L, fromByteBuffer).inUse();
    }

    @Override
    public void logVersions(StringLogger.LineLogger logger) {
        super.logVersions(logger);
        this.propertyIndexStore.logVersions(logger);
        this.stringPropertyStore.logVersions(logger);
        this.arrayPropertyStore.logVersions(logger);
    }

    @Override
    public void logIdUsage(StringLogger.LineLogger logger) {
        super.logIdUsage(logger);
        this.propertyIndexStore.logIdUsage(logger);
        this.stringPropertyStore.logIdUsage(logger);
        this.arrayPropertyStore.logIdUsage(logger);
    }

    @Override
    public String toString() {
        return super.toString() + "[blocksPerRecord:" + PropertyType.getPayloadSizeLongs() + "]";
    }

    public static abstract class Configuration
    extends AbstractStore.Configuration {
    }
}

