/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;
import org.neo4j.kernel.impl.nioneo.store.MappedMemException;
import org.neo4j.kernel.impl.nioneo.store.MappedPersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceRow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PlainPersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;

public class PersistenceWindowPool {
    private static final int MAX_BRICK_COUNT = 100000;
    private final String storeName;
    private final int blockSize;
    private FileChannel fileChannel;
    private final ConcurrentMap<Integer, PersistenceRow> activeRowWindows = new ConcurrentHashMap<Integer, PersistenceRow>();
    private long availableMem = 0L;
    private long memUsed = 0L;
    private int brickCount = 0;
    private int brickSize = 0;
    private BrickElement[] brickArray = new BrickElement[0];
    private int brickMiss = 0;
    private static Logger log = Logger.getLogger(PersistenceWindowPool.class.getName());
    private static final int REFRESH_BRICK_COUNT = 50000;
    private final FileChannel.MapMode mapMode;
    private int hit = 0;
    private int miss = 0;
    private int switches = 0;
    private int ooe = 0;
    private boolean useMemoryMapped = true;
    private final boolean readOnly;
    private static final Comparator<BrickElement> BRICK_SORTER = new Comparator<BrickElement>(){

        @Override
        public int compare(BrickElement o1, BrickElement o2) {
            return o1.getHit() - o2.getHit();
        }
    };

    public PersistenceWindowPool(String storeName, int blockSize, FileChannel fileChannel, long mappedMem, boolean useMemoryMappedBuffers, boolean readOnly) {
        this.storeName = storeName;
        this.blockSize = blockSize;
        this.fileChannel = fileChannel;
        this.availableMem = mappedMem;
        this.useMemoryMapped = useMemoryMappedBuffers;
        this.readOnly = readOnly;
        this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.setupBricks();
        this.dumpStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceWindow acquire(long position, OperationType operationType) {
        LockableWindow window = null;
        if (this.brickMiss >= 50000) {
            this.refreshBricks();
        }
        boolean readFullRow = false;
        while (window == null) {
            if (this.brickSize > 0) {
                int brickIndex = this.positionToBrickIndex(position);
                if (brickIndex < this.brickArray.length) {
                    BrickElement brick = this.brickArray[brickIndex];
                    window = brick.getWindow();
                    if (window != null && !window.markAsInUse()) {
                        window = null;
                    }
                    brick.setHit();
                } else {
                    this.expandBricks(brickIndex + 1);
                    window = this.brickArray[brickIndex].getWindow();
                }
            }
            if (window == null) {
                PersistenceRow dpw;
                ++this.miss;
                ++this.brickMiss;
                if (operationType == OperationType.READ) {
                    readFullRow = true;
                }
                if ((dpw = (PersistenceRow)this.activeRowWindows.get((int)position)) != null && dpw.markAsInUse()) {
                    window = dpw;
                    break;
                }
                dpw = new PersistenceRow(position, this.blockSize, this.fileChannel);
                PersistenceRow existing = this.activeRowWindows.putIfAbsent((int)position, dpw);
                if (existing == null && dpw.markAsInUse()) {
                    window = dpw;
                    continue;
                }
                dpw.close();
                readFullRow = false;
                continue;
            }
            ++this.hit;
        }
        window.lock();
        if (readFullRow) {
            PersistenceRow dpw = (PersistenceRow)window;
            boolean success = false;
            try {
                dpw.readFullWindow();
                success = true;
            }
            finally {
                if (!success) {
                    this.activeRowWindows.remove((int)dpw.position());
                    window.unLock();
                }
            }
        }
        window.setOperationType(operationType);
        return window;
    }

    private int positionToBrickIndex(long position) {
        return (int)(position * (long)this.blockSize / (long)this.brickSize);
    }

    private long brickIndexToPosition(int brickIndex) {
        return (long)brickIndex * (long)this.brickSize / (long)this.blockSize;
    }

    void dumpStatistics() {
        log.finest(this.storeName + " hit=" + this.hit + " miss=" + this.miss + " switches=" + this.switches + " ooe=" + this.ooe);
    }

    public void release(PersistenceWindow window) {
        if (window instanceof PersistenceRow) {
            PersistenceRow dpw = (PersistenceRow)window;
            dpw.writeOutAndClose();
            if (this.brickSize > 0 && dpw.getOperationType() == OperationType.WRITE) {
                this.applyChangesToWindowIfNecessary(dpw);
            }
            dpw.unLock();
            if (dpw.isFree()) {
                this.activeRowWindows.remove((int)dpw.position(), dpw);
            }
        } else {
            ((LockableWindow)window).unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChangesToWindowIfNecessary(PersistenceRow dpw) {
        LockableWindow existingBrickWindow;
        int brickIndex = this.positionToBrickIndex(dpw.position());
        LockableWindow lockableWindow = existingBrickWindow = brickIndex < this.brickArray.length ? this.brickArray[brickIndex].getWindow() : null;
        if (existingBrickWindow != null && !(existingBrickWindow instanceof MappedPersistenceWindow) && existingBrickWindow.markAsInUse()) {
            existingBrickWindow.lock();
            try {
                existingBrickWindow.acceptContents(dpw);
            }
            finally {
                existingBrickWindow.unLock();
            }
        }
    }

    synchronized void close() {
        this.flushAll();
        for (BrickElement element : this.brickArray) {
            if (element.getWindow() == null) continue;
            element.getWindow().close();
            element.setWindow(null);
        }
        this.fileChannel = null;
        this.activeRowWindows.clear();
        this.dumpStatistics();
    }

    void flushAll() {
        if (this.readOnly) {
            return;
        }
        for (BrickElement element : this.brickArray) {
            LockableWindow window = element.getWindow();
            if (window == null) continue;
            window.force();
        }
        try {
            this.fileChannel.force(false);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to flush file channel " + this.storeName, e);
        }
    }

    private void setupBricks() {
        long fileSize = -1L;
        try {
            fileSize = this.fileChannel.size();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to get file size for " + this.storeName, e);
        }
        if (this.blockSize == 0) {
            return;
        }
        if (this.availableMem > 0L && this.availableMem < (long)this.blockSize * 10L) {
            this.logWarn("Unable to use " + this.availableMem + "b as memory mapped windows, need at least " + this.blockSize * 10 + "b (block size * 10)");
            this.logWarn("Memory mapped windows have been turned off");
            this.availableMem = 0L;
            this.brickCount = 0;
            this.brickSize = 0;
            return;
        }
        if (this.availableMem > 0L && fileSize > 0L) {
            double ratio = ((double)this.availableMem + 0.0) / (double)fileSize;
            if (ratio >= 1.0) {
                this.brickSize = (int)(this.availableMem / 1000L);
                if (this.brickSize < 0) {
                    this.brickSize = Integer.MAX_VALUE;
                }
                this.brickSize = this.brickSize / this.blockSize * this.blockSize;
                this.brickCount = (int)(fileSize / (long)this.brickSize);
            } else {
                this.brickCount = (int)(1000.0 / ratio);
                if (this.brickCount > 100000) {
                    this.brickCount = 100000;
                }
                if (fileSize / (long)this.brickCount > this.availableMem) {
                    this.logWarn("Unable to use " + this.availableMem / 1024L + "kb as memory mapped windows, need at least " + fileSize / (long)this.brickCount / 1024L + "kb");
                    this.logWarn("Memory mapped windows have been turned off");
                    this.availableMem = 0L;
                    this.brickCount = 0;
                    this.brickSize = 0;
                    return;
                }
                this.brickSize = (int)(fileSize / (long)this.brickCount);
                if (this.brickSize < 0) {
                    this.brickSize = Integer.MAX_VALUE;
                    this.brickSize = this.brickSize / this.blockSize * this.blockSize;
                    this.brickCount = (int)(fileSize / (long)this.brickSize);
                } else {
                    this.brickSize = this.brickSize / this.blockSize * this.blockSize;
                }
                assert (this.brickSize > this.blockSize);
            }
        } else if (this.availableMem > 0L) {
            this.brickSize = (int)(this.availableMem / 100L);
            if (this.brickSize < 0) {
                this.brickSize = Integer.MAX_VALUE;
            }
            this.brickSize = this.brickSize / this.blockSize * this.blockSize;
        }
        this.brickArray = new BrickElement[this.brickCount];
        for (int i = 0; i < this.brickCount; ++i) {
            BrickElement element;
            this.brickArray[i] = element = new BrickElement(i);
        }
    }

    private void freeWindows(int nr) {
        int i;
        if (this.brickSize <= 0) {
            return;
        }
        ArrayList<BrickElement> mappedBricks = new ArrayList<BrickElement>();
        for (i = 0; i < this.brickCount; ++i) {
            BrickElement be = this.brickArray[i];
            if (be.getWindow() == null) continue;
            mappedBricks.add(be);
        }
        Collections.sort(mappedBricks, BRICK_SORTER);
        for (i = 0; i < nr && i < mappedBricks.size(); ++i) {
            BrickElement mappedBrick = (BrickElement)mappedBricks.get(i);
            LockableWindow window = mappedBrick.getWindow();
            if (!window.writeOutAndCloseIfFree(this.readOnly)) continue;
            mappedBrick.setWindow(null);
            this.memUsed -= (long)this.brickSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBricks() {
        if (this.brickMiss < 50000 || this.brickSize <= 0) {
            return;
        }
        PersistenceWindowPool persistenceWindowPool = this;
        synchronized (persistenceWindowPool) {
            this.brickMiss = 0;
            Pair<List<BrickElement>, List<BrickElement>> currentMappings = this.gatherMappedVersusUnmappedWindows();
            List<BrickElement> mappedBricks = currentMappings.first();
            List<BrickElement> unmappedBricks = currentMappings.other();
            int unmappedIndex = unmappedBricks.size() - 1;
            while (this.memUsed + (long)this.brickSize <= this.availableMem && unmappedIndex >= 0) {
                BrickElement unmappedBrick;
                if ((unmappedBrick = unmappedBricks.get(unmappedIndex--)).getHit() == 0) {
                    return;
                }
                this.allocateNewWindow(unmappedBrick);
            }
            int mappedIndex = 0;
            while (unmappedIndex >= 0 && mappedIndex < mappedBricks.size()) {
                BrickElement mappedBrick = mappedBricks.get(mappedIndex++);
                BrickElement unmappedBrick = unmappedBricks.get(unmappedIndex--);
                if (mappedBrick.getHit() >= unmappedBrick.getHit()) break;
                LockableWindow window = mappedBrick.getWindow();
                if (!window.writeOutAndCloseIfFree(this.readOnly)) continue;
                mappedBrick.setWindow(null);
                this.memUsed -= (long)this.brickSize;
                if (!this.allocateNewWindow(unmappedBrick)) continue;
                ++this.switches;
            }
        }
    }

    private Pair<List<BrickElement>, List<BrickElement>> gatherMappedVersusUnmappedWindows() {
        ArrayList<BrickElement> mappedBricks = new ArrayList<BrickElement>();
        ArrayList<BrickElement> unmappedBricks = new ArrayList<BrickElement>();
        for (int i = 0; i < this.brickCount; ++i) {
            BrickElement be = this.brickArray[i];
            if (be.getWindow() != null) {
                mappedBricks.add(be);
            } else {
                unmappedBricks.add(be);
            }
            be.refresh();
        }
        Collections.sort(unmappedBricks, BRICK_SORTER);
        Collections.sort(mappedBricks, BRICK_SORTER);
        return Pair.of(mappedBricks, unmappedBricks);
    }

    private synchronized void expandBricks(int newBrickCount) {
        if (newBrickCount > this.brickCount) {
            BrickElement[] tmpArray = new BrickElement[newBrickCount];
            System.arraycopy(this.brickArray, 0, tmpArray, 0, this.brickArray.length);
            if (this.memUsed + (long)this.brickSize >= this.availableMem) {
                this.freeWindows(1);
            }
            for (int i = this.brickArray.length; i < tmpArray.length; ++i) {
                BrickElement be;
                tmpArray[i] = be = new BrickElement(i);
                if (this.memUsed + (long)this.brickSize > this.availableMem) continue;
                this.allocateNewWindow(be);
            }
            this.brickArray = tmpArray;
            this.brickCount = tmpArray.length;
        }
    }

    private boolean allocateNewWindow(BrickElement brick) {
        try {
            LockableWindow window = null;
            if (this.useMemoryMapped) {
                window = new MappedPersistenceWindow(this.brickIndexToPosition(brick.index()), this.blockSize, this.brickSize, this.fileChannel, this.mapMode);
            } else {
                PlainPersistenceWindow dpw = new PlainPersistenceWindow(this.brickIndexToPosition(brick.index()), this.blockSize, this.brickSize, this.fileChannel);
                dpw.readFullWindow();
                window = dpw;
            }
            brick.setWindow(window);
            this.memUsed += (long)this.brickSize;
            return true;
        }
        catch (MappedMemException e) {
            ++this.ooe;
            this.logWarn("Unable to memory map", e);
        }
        catch (OutOfMemoryError e) {
            ++this.ooe;
            this.logWarn("Unable to allocate direct buffer", e);
        }
        return false;
    }

    private void dumpStatus() {
        try {
            log.fine("[" + this.storeName + "] brickCount=" + this.brickCount + " brickSize=" + this.brickSize + "b mappedMem=" + this.availableMem + "b (storeSize=" + this.fileChannel.size() + "b)");
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to get file size for " + this.storeName, e);
        }
    }

    private void logWarn(String logMessage) {
        log.warning("[" + this.storeName + "] " + logMessage);
    }

    private void logWarn(String logMessage, Throwable cause) {
        log.log(Level.WARNING, "[" + this.storeName + "] " + logMessage, cause);
    }

    WindowPoolStats getStats() {
        return new WindowPoolStats(this.storeName, this.availableMem, this.memUsed, this.brickCount, this.brickSize, this.hit, this.miss, this.ooe);
    }

    private static class BrickElement {
        private final int index;
        private int hitCount;
        private volatile LockableWindow window;

        BrickElement(int index) {
            this.index = index;
        }

        void setWindow(LockableWindow window) {
            this.window = window;
        }

        LockableWindow getWindow() {
            return this.window;
        }

        int index() {
            return this.index;
        }

        void setHit() {
            this.hitCount += 10;
            if (this.hitCount < 0) {
                this.hitCount -= 10;
            }
        }

        int getHit() {
            return this.hitCount;
        }

        void refresh() {
            this.hitCount = this.window == null ? (int)((double)this.hitCount / 1.25) : (int)((double)this.hitCount / 1.15);
        }

        public String toString() {
            return "" + this.hitCount + (this.window == null ? "x" : "o");
        }
    }
}

