/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialStateFactory;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.MultiEvaluator;
import org.neo4j.kernel.impl.traversal.TraverserImpl;

public final class TraversalDescriptionImpl
implements TraversalDescription {
    final PathExpander expander;
    final InitialStateFactory initialState;
    final UniquenessFactory uniqueness;
    final Object uniquenessParameter;
    final Evaluator evaluator;
    final BranchOrderingPolicy branchOrdering;
    final Comparator<? super Path> sorting;
    final Collection<Node> endNodes;

    public TraversalDescriptionImpl() {
        this(Traversal.emptyPathExpander(), Uniqueness.NODE_GLOBAL, null, Evaluators.all(), InitialStateFactory.NO_STATE, Traversal.preorderDepthFirst(), null, null);
    }

    private TraversalDescriptionImpl(PathExpander expander, UniquenessFactory uniqueness, Object uniquenessParameter, Evaluator evaluator, InitialStateFactory<?> initialState, BranchOrderingPolicy branchOrdering, Comparator<? super Path> sorting, Collection<Node> endNodes) {
        this.expander = expander;
        this.uniqueness = uniqueness;
        this.uniquenessParameter = uniquenessParameter;
        this.evaluator = evaluator;
        this.branchOrdering = branchOrdering;
        this.sorting = sorting;
        this.endNodes = endNodes;
        this.initialState = initialState;
    }

    @Override
    public Traverser traverse(Node startNode) {
        return new TraverserImpl(this, Arrays.asList(startNode));
    }

    @Override
    public Traverser traverse(Node ... startNodes) {
        return new TraverserImpl(this, Arrays.asList(startNodes));
    }

    @Override
    public TraversalDescription uniqueness(UniquenessFactory uniqueness) {
        return new TraversalDescriptionImpl(this.expander, uniqueness, null, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes);
    }

    @Override
    public TraversalDescription uniqueness(UniquenessFactory uniqueness, Object parameter) {
        if (this.uniqueness == uniqueness && (this.uniquenessParameter == null ? parameter == null : this.uniquenessParameter.equals(parameter))) {
            return this;
        }
        return new TraversalDescriptionImpl(this.expander, uniqueness, parameter, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes);
    }

    @Override
    public TraversalDescription evaluator(Evaluator evaluator) {
        if (this.evaluator == evaluator) {
            return this;
        }
        TraversalDescriptionImpl.nullCheck(evaluator, Evaluator.class, "RETURN_ALL");
        return new TraversalDescriptionImpl(this.expander, this.uniqueness, this.uniquenessParameter, TraversalDescriptionImpl.addEvaluator(this.evaluator, evaluator), this.initialState, this.branchOrdering, this.sorting, this.endNodes);
    }

    protected static Evaluator addEvaluator(Evaluator existing, Evaluator toAdd) {
        if (existing instanceof MultiEvaluator) {
            return ((MultiEvaluator)existing).add(toAdd);
        }
        return existing == Evaluators.all() ? toAdd : new MultiEvaluator(existing, toAdd);
    }

    protected static <T> void nullCheck(T parameter, Class<T> parameterType, String defaultName) {
        if (parameter == null) {
            String typeName = parameterType.getSimpleName();
            throw new IllegalArgumentException(typeName + " may not be null, use " + typeName + "." + defaultName + " instead.");
        }
    }

    @Override
    public TraversalDescription order(BranchOrderingPolicy order) {
        if (this.branchOrdering == order) {
            return this;
        }
        return new TraversalDescriptionImpl(this.expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, order, this.sorting, this.endNodes);
    }

    @Override
    public TraversalDescription depthFirst() {
        return this.order(Traversal.preorderDepthFirst());
    }

    @Override
    public TraversalDescription breadthFirst() {
        return this.order(Traversal.preorderBreadthFirst());
    }

    @Override
    public TraversalDescription relationships(RelationshipType type) {
        return this.relationships(type, Direction.BOTH);
    }

    @Override
    public TraversalDescription relationships(RelationshipType type, Direction direction) {
        if (this.expander instanceof Expander) {
            return this.expand(((Expander)((Object)this.expander)).add(type, direction));
        }
        throw new IllegalStateException("The current expander cannot be added to");
    }

    @Override
    public TraversalDescription expand(RelationshipExpander expander) {
        return this.expand(StandardExpander.toPathExpander(expander));
    }

    @Override
    public TraversalDescription expand(PathExpander<?> expander) {
        if (expander.equals(this.expander)) {
            return this;
        }
        return new TraversalDescriptionImpl(expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes);
    }

    @Override
    public <STATE> TraversalDescription expand(PathExpander<STATE> expander, InitialStateFactory<STATE> initialState) {
        return new TraversalDescriptionImpl(expander, this.uniqueness, this.uniquenessParameter, this.evaluator, initialState, this.branchOrdering, this.sorting, this.endNodes);
    }

    @Override
    public TraversalDescription sort(Comparator<? super Path> sorting) {
        return new TraversalDescriptionImpl(this.expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, this.branchOrdering, sorting, this.endNodes);
    }

    @Override
    public TraversalDescription reverse() {
        return new TraversalDescriptionImpl(this.expander.reverse(), this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes);
    }
}

