/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;

public class BufferingLogger
extends StringLogger {
    private List<LogMessage> buffer = new ArrayList<LogMessage>();

    @Override
    public void logMessage(String msg) {
        this.logMessage(msg, null);
    }

    @Override
    public void logMessage(String msg, Throwable throwable) {
        this.logMessage(msg, throwable, false);
    }

    @Override
    public void logMessage(String msg, boolean flush) {
        this.logMessage(msg, null, flush);
    }

    @Override
    public void logMessage(String msg, Throwable cause, boolean flush) {
        this.buffer.add(new LogMessage(msg, cause, flush));
    }

    @Override
    public void logLongMessage(String msg, Visitor<StringLogger.LineLogger> source, boolean flush) {
        source.visit(new StringLogger.LineLoggerImpl(this));
    }

    @Override
    public void addRotationListener(Runnable listener) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected void logLine(String line) {
        this.logMessage(line);
    }

    @Override
    public void flush() {
        this.logMessage("", true);
    }

    @Override
    public void close() {
    }

    public void replayInto(StringLogger other) {
        List<LogMessage> oldBuffer = this.buffer;
        this.buffer = new ArrayList<LogMessage>();
        for (LogMessage message : oldBuffer) {
            if (message.throwable != null) {
                other.logMessage(message.message, message.throwable, message.flush);
                continue;
            }
            other.logMessage(message.message, message.flush);
        }
    }

    public String toString() {
        PrintWriter sb = new PrintWriter(new StringWriter());
        for (LogMessage message : this.buffer) {
            sb.println(message.message);
            message.throwable.printStackTrace(sb);
        }
        return sb.toString();
    }

    private static class LogMessage {
        public String message;
        public Throwable throwable;
        public boolean flush;

        public LogMessage(String message, Throwable throwable, boolean flush) {
            this.message = message;
            this.throwable = throwable;
            this.flush = flush;
        }
    }
}

