/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.kernel.impl.cache.EntityWithSize;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

abstract class ArrayBasedPrimitive
extends Primitive
implements EntityWithSize {
    private volatile PropertyData[] properties;
    private volatile int registeredSize;

    ArrayBasedPrimitive(boolean newPrimitive) {
        super(newPrimitive);
    }

    @Override
    public void setRegisteredSize(int size) {
        this.registeredSize = size;
    }

    @Override
    public int getRegisteredSize() {
        return this.registeredSize;
    }

    @Override
    public int size() {
        int size = 16;
        if (this.properties != null) {
            size = SizeOfs.withArrayOverheadIncludingReferences(size, this.properties.length);
            for (PropertyData data : this.properties) {
                size += data.size();
            }
        }
        return SizeOfs.withObjectOverhead(size);
    }

    protected abstract void updateSize(NodeManager var1);

    @Override
    protected void setEmptyProperties() {
        this.properties = NO_PROPERTIES;
    }

    private PropertyData[] toPropertyArray(ArrayMap<Integer, PropertyData> loadedProperties) {
        if (loadedProperties == null || loadedProperties.size() == 0) {
            return NO_PROPERTIES;
        }
        PropertyData[] result = new PropertyData[loadedProperties.size()];
        int i = 0;
        for (PropertyData property : loadedProperties.values()) {
            result[i++] = property;
        }
        return result;
    }

    @Override
    public void setProperties(ArrayMap<Integer, PropertyData> properties, NodeManager nodeManager) {
        this.properties = this.toPropertyArray(properties);
        this.updateSize(nodeManager);
    }

    @Override
    protected PropertyData[] allProperties() {
        return this.properties;
    }

    @Override
    protected PropertyData getPropertyForIndex(int keyId) {
        for (PropertyData property : this.properties) {
            if (property.getIndex() != keyId) continue;
            return property;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap, long firstProp, NodeManager nodeManager) {
        ArrayBasedPrimitive arrayBasedPrimitive = this;
        synchronized (arrayBasedPrimitive) {
            PropertyData existingProperty;
            int i;
            PropertyData[] newArray = this.properties;
            if (newArray == null) {
                return;
            }
            int extraLength = 0;
            if (cowPropertyAddMap != null) {
                extraLength += cowPropertyAddMap.size();
            }
            int newArraySize = newArray.length;
            if (extraLength > 0) {
                PropertyData[] oldArray = newArray;
                newArray = new PropertyData[oldArray.length + extraLength];
                System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            } else {
                newArray = (PropertyData[])newArray.clone();
            }
            if (cowPropertyRemoveMap != null) {
                block3: for (Integer keyIndex : cowPropertyRemoveMap.keySet()) {
                    for (i = 0; i < newArraySize; ++i) {
                        existingProperty = newArray[i];
                        if (existingProperty.getIndex() != keyIndex.intValue()) continue;
                        int swapWith = --newArraySize;
                        newArray[i] = newArray[swapWith];
                        newArray[swapWith] = null;
                        continue block3;
                    }
                }
            }
            if (cowPropertyAddMap != null) {
                block5: for (PropertyData addedProperty : cowPropertyAddMap.values()) {
                    for (i = 0; i < newArray.length; ++i) {
                        existingProperty = newArray[i];
                        if (existingProperty != null && addedProperty.getIndex() != existingProperty.getIndex()) continue;
                        newArray[i] = addedProperty;
                        if (existingProperty != null) continue block5;
                        ++newArraySize;
                        continue block5;
                    }
                }
            }
            if (newArraySize < newArray.length) {
                PropertyData[] compactedNewArray = new PropertyData[newArraySize];
                System.arraycopy(newArray, 0, compactedNewArray, 0, newArraySize);
                this.properties = compactedNewArray;
            } else {
                this.properties = newArray;
            }
            this.updateSize(nodeManager);
        }
    }
}

