/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.collection.Iterables;

public class SystemPropertiesConfiguration {
    private Iterable<Class<?>> settingsClasses;

    public SystemPropertiesConfiguration(Class<?> ... settingsClasses) {
        this(Iterables.iterable(settingsClasses));
    }

    public SystemPropertiesConfiguration(Iterable<Class<?>> settingsClasses) {
        this.settingsClasses = settingsClasses;
    }

    public Map<String, String> apply(Map<String, String> config) {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
            String key = (String)prop.getKey();
            for (Class<?> settingsClass : this.settingsClasses) {
                for (Field field : settingsClass.getFields()) {
                    try {
                        GraphDatabaseSetting setting = (GraphDatabaseSetting)field.get(null);
                        if (!setting.name().equals(key)) continue;
                        setting.validate((String)prop.getValue());
                        systemProperties.put(key, (String)prop.getValue());
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        systemProperties.putAll(config);
        return systemProperties;
    }
}

