/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.configuration.Config;

public interface ConfigModifier {
    public void applyTo(Session var1);

    public static class Session {
        private Config config;
        private Set<Modification> modifications = new HashSet<Modification>();

        public Session(Config config) {
            this.config = config;
        }

        public <T> T get(GraphDatabaseSetting<T> setting) {
            return this.config.get(setting);
        }

        public Collection<String> getKeys() {
            return this.config.getKeys();
        }

        public <T> void set(GraphDatabaseSetting<T> setting, String value) {
            this.modifications.add(new Modification(setting, value));
        }

        protected Set<Modification> getModifications() {
            return this.modifications;
        }
    }

    public static class Modification {
        private String value;
        private GraphDatabaseSetting<?> setting;

        public Modification(GraphDatabaseSetting<?> setting, String value) {
            this.setting = setting;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public GraphDatabaseSetting<?> getSetting() {
            return this.setting;
        }
    }

    public static class Modifications
    implements ConfigModifier {
        private Set<Modification> modifications = new HashSet<Modification>();

        @Override
        public void applyTo(Session session) {
            for (Modification m : this.modifications) {
                session.set(m.getSetting(), m.getValue());
            }
        }

        public <T> Modifications set(GraphDatabaseSetting<T> setting, String value) {
            this.modifications.add(new Modification(setting, value));
            return this;
        }
    }
}

