/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.DaemonThreadFactory;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.AutoConfigurator;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultLastCommittedTxIdSetter;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.IndexManagerImpl;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelDiagnostics;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.LegacyIndexIterable;
import org.neo4j.kernel.NodeAutoIndexerImpl;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.RelationshipAutoIndexerImpl;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.TransactionBuilderImpl;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.MeasureDoNothing;
import org.neo4j.kernel.impl.cache.MonitorGc;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.DefaultCaches;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.ReadOnlyNodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.core.TransactionEventsSyncHook;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.ReadOnlyTxManager;
import org.neo4j.kernel.impl.transaction.TransactionManagerProvider;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.DefaultLogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.logging.ClassicLoggingService;
import org.neo4j.kernel.logging.LogbackService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.tooling.GlobalGraphOperations;

public abstract class AbstractGraphDatabase
implements GraphDatabaseService,
GraphDatabaseAPI {
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private static final long MAX_RELATIONSHIP_ID = IdType.RELATIONSHIP.getMaxValue();
    protected String storeDir;
    protected Map<String, String> params;
    private final Iterable<KernelExtension> kernelExtensions;
    protected StoreId storeId;
    private Transaction placeboTransaction = null;
    private final TransactionBuilder defaultTxBuilder = new TransactionBuilderImpl(this, ForceMode.forced);
    protected Logging logging;
    protected StringLogger msgLog;
    protected KernelEventHandlers kernelEventHandlers;
    protected TransactionEventHandlers transactionEventHandlers;
    protected RelationshipTypeHolder relationshipTypeHolder;
    protected NodeManager nodeManager;
    protected Iterable<IndexProvider> indexProviders;
    protected IndexManagerImpl indexManager;
    protected Config config;
    protected KernelPanicEventGenerator kernelPanicEventGenerator;
    protected TxHook txHook;
    protected FileSystemAbstraction fileSystem;
    protected XaDataSourceManager xaDataSourceManager;
    protected RagManager ragManager;
    protected LockManager lockManager;
    protected IdGeneratorFactory idGeneratorFactory;
    protected RelationshipTypeCreator relationshipTypeCreator;
    protected LastCommittedTxIdSetter lastCommittedTxIdSetter;
    protected NioNeoDbPersistenceSource persistenceSource;
    protected TxEventSyncHookFactory syncHook;
    protected PersistenceManager persistenceManager;
    protected PropertyIndexManager propertyIndexManager;
    protected LockReleaser lockReleaser;
    protected IndexStore indexStore;
    protected LogBufferFactory logBufferFactory;
    protected AbstractTransactionManager txManager;
    protected TxIdGenerator txIdGenerator;
    protected StoreFactory storeFactory;
    protected XaFactory xaFactory;
    protected DiagnosticsManager diagnosticsManager;
    protected NeoStoreXaDataSource neoDataSource;
    protected RecoveryVerifier recoveryVerifier;
    protected Guard guard;
    protected MeasureDoNothing monitorGc;
    protected NodeAutoIndexerImpl nodeAutoIndexer;
    protected RelationshipAutoIndexerImpl relAutoIndexer;
    protected KernelData extensions;
    protected Caches caches;
    protected final LifeSupport life = new LifeSupport();
    private final Map<String, CacheProvider> cacheProviders;

    protected AbstractGraphDatabase(String storeDir, Map<String, String> params, Iterable<IndexProvider> indexProviders, Iterable<KernelExtension> kernelExtensions, Iterable<CacheProvider> cacheProviders) {
        this.params = params;
        this.cacheProviders = this.mapCacheProviders(cacheProviders);
        this.indexProviders = indexProviders;
        this.kernelExtensions = kernelExtensions;
        params.put(Configuration.store_dir.name(), storeDir);
        this.config = new Config(params, this.getSettingsClasses());
        this.storeDir = this.config.get(Configuration.store_dir);
    }

    private Map<String, CacheProvider> mapCacheProviders(Iterable<CacheProvider> cacheProviders) {
        HashMap<String, CacheProvider> map = new HashMap<String, CacheProvider>();
        for (CacheProvider provider : cacheProviders) {
            map.put(provider.getName(), provider);
        }
        return map;
    }

    protected void run() {
        this.create();
        try {
            this.life.start();
        }
        catch (LifecycleException throwable) {
            this.msgLog.logMessage("Startup failed", throwable);
            this.shutdown();
            throw throwable;
        }
    }

    private void create() {
        this.fileSystem = this.life.add(this.createFileSystemAbstraction());
        this.logging = this.createStringLogger();
        AutoConfigurator autoConfigurator = new AutoConfigurator(this.fileSystem, this.config.get(NeoStoreXaDataSource.Configuration.store_dir), this.config.get(GraphDatabaseSettings.use_memory_mapped_buffers), this.config.get(GraphDatabaseSettings.dump_configuration));
        Map<String, String> configParams = this.config.getParams();
        Map<String, String> autoConfiguration = autoConfigurator.configure();
        for (Map.Entry<String, String> autoConfig : autoConfiguration.entrySet()) {
            if (this.params.containsKey(autoConfig.getKey())) continue;
            String key = autoConfig.getKey();
            configParams.put(autoConfig.getKey(), autoConfig.getValue());
        }
        this.config.applyChanges(configParams);
        this.msgLog = this.logging.getLogger("neo4j");
        this.config.setLogger(this.msgLog);
        boolean readOnly = this.config.get(Configuration.read_only);
        String cacheTypeName = this.config.get(Configuration.cache_type);
        CacheProvider cacheProvider = this.cacheProviders.get(cacheTypeName);
        if (cacheProvider == null) {
            throw new IllegalArgumentException("No cache type '" + cacheTypeName + "'");
        }
        this.kernelEventHandlers = new KernelEventHandlers();
        this.caches = this.createCaches();
        this.diagnosticsManager = this.life.add(new DiagnosticsManager(this.logging.getLogger("neo4j.diagnostics")));
        this.kernelPanicEventGenerator = new KernelPanicEventGenerator(this.kernelEventHandlers);
        this.txHook = this.createTxHook();
        this.xaDataSourceManager = this.life.add(new XaDataSourceManager(this.logging.getLogger("neo4j.datasource")));
        this.guard = this.config.get(Configuration.execution_guard_enabled) != false ? new Guard(this.msgLog) : null;
        this.xaDataSourceManager = this.life.add(new XaDataSourceManager(this.msgLog));
        if (readOnly) {
            this.txManager = new ReadOnlyTxManager(this.xaDataSourceManager);
        } else {
            String serviceName = this.config.get(GraphDatabaseSettings.tx_manager_impl);
            if (serviceName == null) {
                this.txManager = new TxManager(this.storeDir, this.xaDataSourceManager, this.kernelPanicEventGenerator, this.txHook, this.logging.getLogger("neo4j.txmanager"), this.fileSystem);
            } else {
                TransactionManagerProvider provider = Service.load(TransactionManagerProvider.class, serviceName);
                if (provider == null) {
                    throw new IllegalStateException("Unknown transaction manager implementation: " + serviceName);
                }
                this.txManager = provider.loadTransactionManager(this.storeDir, this.kernelPanicEventGenerator, this.txHook, this.logging.getLogger("neo4j.txmanager"), this.fileSystem);
            }
        }
        this.life.add(this.txManager);
        this.transactionEventHandlers = new TransactionEventHandlers(this.txManager);
        this.txIdGenerator = this.createTxIdGenerator();
        this.ragManager = new RagManager(this.txManager);
        this.lockManager = this.createLockManager();
        this.idGeneratorFactory = this.createIdGeneratorFactory();
        this.relationshipTypeCreator = this.createRelationshipTypeCreator();
        this.lastCommittedTxIdSetter = this.createLastCommittedTxIdSetter();
        this.persistenceSource = this.life.add(new NioNeoDbPersistenceSource(this.xaDataSourceManager));
        this.syncHook = new DefaultTxEventSyncHookFactory();
        this.persistenceManager = new PersistenceManager(this.txManager, this.persistenceSource, this.syncHook, this.lockReleaser);
        this.propertyIndexManager = this.life.add(new PropertyIndexManager(this.txManager, this.persistenceManager, this.persistenceSource));
        this.lockReleaser = new LockReleaser(this.lockManager, this.txManager, this.nodeManager, this.propertyIndexManager);
        this.persistenceManager.setLockReleaser(this.lockReleaser);
        this.relationshipTypeHolder = new RelationshipTypeHolder(this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeCreator);
        this.caches.configure(cacheProvider, this.config);
        Cache<NodeImpl> nodeCache = this.diagnosticsManager.tryAppendProvider(this.caches.node());
        Cache<RelationshipImpl> relCache = this.diagnosticsManager.tryAppendProvider(this.caches.relationship());
        this.nodeManager = this.guard != null ? this.createGuardedNodeManager(readOnly, cacheProvider, nodeCache, relCache) : this.createNodeManager(readOnly, cacheProvider, nodeCache, relCache);
        this.life.add(this.nodeManager);
        this.lockReleaser.setNodeManager(this.nodeManager);
        this.indexStore = new IndexStore(this.storeDir, this.fileSystem);
        this.diagnosticsManager.prependProvider(this.config);
        this.params = this.config.getParams();
        this.logBufferFactory = new DefaultLogBufferFactory();
        this.extensions = this.life.add(this.createKernelData());
        if (this.config.get(Configuration.load_kernel_extensions).booleanValue()) {
            this.life.add(new DefaultKernelExtensionLoader(this.extensions));
        }
        if (this.indexProviders == null) {
            this.indexProviders = new LegacyIndexIterable();
        }
        this.indexManager = new IndexManagerImpl(this.config, this.indexStore, this.xaDataSourceManager, this.txManager, this);
        this.nodeAutoIndexer = this.life.add(new NodeAutoIndexerImpl(this.config, this.indexManager, this.nodeManager));
        this.relAutoIndexer = this.life.add(new RelationshipAutoIndexerImpl(this.config, this.indexManager, this.nodeManager));
        this.indexManager.setNodeAutoIndexer(this.nodeAutoIndexer);
        this.indexManager.setRelAutoIndexer(this.relAutoIndexer);
        this.recoveryVerifier = this.createRecoveryVerifier();
        this.storeFactory = this.createStoreFactory();
        String keepLogicalLogsConfig = this.config.get(GraphDatabaseSettings.keep_logical_logs);
        this.xaFactory = new XaFactory(this.config, this.txIdGenerator, this.txManager, this.logBufferFactory, this.fileSystem, this.logging.getLogger("neo4j.xafactory"), this.recoveryVerifier, LogPruneStrategies.fromConfigValue(this.fileSystem, keepLogicalLogsConfig));
        ArrayList<Pair<TransactionInterceptorProvider, Object>> providers = new ArrayList<Pair<TransactionInterceptorProvider, Object>>(2);
        for (TransactionInterceptorProvider provider : Service.load(TransactionInterceptorProvider.class)) {
            String prov = this.params.get(TransactionInterceptorProvider.class.getSimpleName() + "." + provider.name());
            if (prov == null) continue;
            providers.add(Pair.of(provider, prov));
        }
        try {
            this.neoDataSource = new NeoStoreXaDataSource(this.config, this.storeFactory, this.fileSystem, this.lockManager, this.lockReleaser, this.logging.getLogger("neo4j.datasource"), this.xaFactory, providers, new DependencyResolverImpl());
            this.xaDataSourceManager.registerDataSource(this.neoDataSource);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create Neo XA datasource", e);
        }
        this.life.add(new StuffToDoAfterRecovery());
        this.life.add(new MonitorGc(this.config, this.msgLog));
        this.life.add(new DatabaseAvailability());
        this.life.add(this.kernelEventHandlers);
        this.life.add(new ConfigurationChangedRestarter());
    }

    protected RelationshipTypeCreator createRelationshipTypeCreator() {
        return new DefaultRelationshipTypeCreator();
    }

    private NodeManager createNodeManager(boolean readOnly, CacheProvider cacheType, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache) {
        if (readOnly) {
            return new ReadOnlyNodeManager(this.config, this, this.lockManager, this.lockReleaser, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache);
        }
        return new NodeManager(this.config, this, this.lockManager, this.lockReleaser, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache);
    }

    private NodeManager createGuardedNodeManager(boolean readOnly, CacheProvider cacheType, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache) {
        if (readOnly) {
            return new ReadOnlyNodeManager(this.config, this, this.lockManager, this.lockReleaser, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache){

                @Override
                protected Node getNodeByIdOrNull(long nodeId) {
                    AbstractGraphDatabase.this.guard.check();
                    return super.getNodeByIdOrNull(nodeId);
                }

                @Override
                public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
                    AbstractGraphDatabase.this.guard.check();
                    return super.getNodeForProxy(nodeId, lock);
                }

                @Override
                public RelationshipImpl getRelationshipForProxy(long relId, LockType lock) {
                    AbstractGraphDatabase.this.guard.check();
                    return super.getRelationshipForProxy(relId, lock);
                }

                @Override
                protected Relationship getRelationshipByIdOrNull(long relId) {
                    AbstractGraphDatabase.this.guard.check();
                    return super.getRelationshipByIdOrNull(relId);
                }

                @Override
                public Node createNode() {
                    AbstractGraphDatabase.this.guard.check();
                    return super.createNode();
                }

                @Override
                public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, RelationshipType type) {
                    AbstractGraphDatabase.this.guard.check();
                    return super.createRelationship(startNodeProxy, startNode, endNode, type);
                }
            };
        }
        return new NodeManager(this.config, this, this.lockManager, this.lockReleaser, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), nodeCache, relCache){

            @Override
            protected Node getNodeByIdOrNull(long nodeId) {
                AbstractGraphDatabase.this.guard.check();
                return super.getNodeByIdOrNull(nodeId);
            }

            @Override
            public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
                AbstractGraphDatabase.this.guard.check();
                return super.getNodeForProxy(nodeId, lock);
            }

            @Override
            public RelationshipImpl getRelationshipForProxy(long relId, LockType lock) {
                AbstractGraphDatabase.this.guard.check();
                return super.getRelationshipForProxy(relId, lock);
            }

            @Override
            protected Relationship getRelationshipByIdOrNull(long relId) {
                AbstractGraphDatabase.this.guard.check();
                return super.getRelationshipByIdOrNull(relId);
            }

            @Override
            public Node createNode() {
                AbstractGraphDatabase.this.guard.check();
                return super.createNode();
            }

            @Override
            public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, RelationshipType type) {
                AbstractGraphDatabase.this.guard.check();
                return super.createRelationship(startNodeProxy, startNode, endNode, type);
            }
        };
    }

    @Override
    public void shutdown() {
        try {
            this.life.shutdown();
        }
        catch (LifecycleException throwable) {
            this.msgLog.logMessage("Shutdown failed", throwable);
        }
    }

    protected StoreFactory createStoreFactory() {
        return new StoreFactory(this.config, this.idGeneratorFactory, this.fileSystem, this.lastCommittedTxIdSetter, this.logging.getLogger("neo4j.neostore"), this.txHook);
    }

    protected RecoveryVerifier createRecoveryVerifier() {
        return RecoveryVerifier.ALWAYS_VALID;
    }

    protected KernelData createKernelData() {
        return new DefaultKernelData(this.config, this);
    }

    protected LastCommittedTxIdSetter createLastCommittedTxIdSetter() {
        return new DefaultLastCommittedTxIdSetter();
    }

    protected TxIdGenerator createTxIdGenerator() {
        return TxIdGenerator.DEFAULT;
    }

    protected Caches createCaches() {
        return new DefaultCaches(this.msgLog);
    }

    protected RelationshipProxy.RelationshipLookups createRelationshipLookups() {
        return new RelationshipProxy.RelationshipLookups(){

            @Override
            public Node lookupNode(long nodeId) {
                return AbstractGraphDatabase.this.nodeManager.getNodeById(nodeId);
            }

            @Override
            public RelationshipImpl lookupRelationship(long relationshipId) {
                return AbstractGraphDatabase.this.nodeManager.getRelationshipForProxy(relationshipId, null);
            }

            @Override
            public RelationshipImpl lookupRelationship(long relationshipId, LockType lock) {
                return AbstractGraphDatabase.this.nodeManager.getRelationshipForProxy(relationshipId, lock);
            }

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return AbstractGraphDatabase.this;
            }

            @Override
            public NodeManager getNodeManager() {
                return AbstractGraphDatabase.this.nodeManager;
            }

            @Override
            public Node newNodeProxy(long nodeId) {
                return AbstractGraphDatabase.this.nodeManager.newNodeProxyById(nodeId);
            }
        };
    }

    protected NodeProxy.NodeLookup createNodeLookup() {
        return new NodeProxy.NodeLookup(){

            @Override
            public NodeImpl lookup(long nodeId) {
                return AbstractGraphDatabase.this.nodeManager.getNodeForProxy(nodeId, null);
            }

            @Override
            public NodeImpl lookup(long nodeId, LockType lock) {
                return AbstractGraphDatabase.this.nodeManager.getNodeForProxy(nodeId, lock);
            }

            @Override
            public GraphDatabaseService getGraphDatabase() {
                return AbstractGraphDatabase.this;
            }

            @Override
            public NodeManager getNodeManager() {
                return AbstractGraphDatabase.this.nodeManager;
            }
        };
    }

    protected TxHook createTxHook() {
        return new DefaultTxHook();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        return new DefaultIdGeneratorFactory();
    }

    protected LockManager createLockManager() {
        return new LockManager(this.ragManager);
    }

    protected Logging createStringLogger() {
        try {
            this.getClass().getClassLoader().loadClass("ch.qos.logback.classic.LoggerContext");
            return this.life.add(new LogbackService(this.config));
        }
        catch (ClassNotFoundException e) {
            return this.life.add(new ClassicLoggingService(this.config));
        }
    }

    @Override
    public final String getStoreDir() {
        return this.storeDir;
    }

    @Override
    public StoreId getStoreId() {
        return this.storeId;
    }

    @Override
    public Transaction beginTx() {
        return this.tx().begin();
    }

    Transaction beginTx(ForceMode forceMode) {
        if (this.transactionRunning()) {
            if (this.placeboTransaction == null) {
                this.placeboTransaction = new PlaceboTransaction(this.txManager);
            }
            return this.placeboTransaction;
        }
        TopLevelTransaction result = null;
        try {
            this.txManager.begin(forceMode);
            result = new TopLevelTransaction(this.txManager, this.lockManager, this.lockReleaser);
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to begin transaction", e);
        }
        return result;
    }

    public boolean transactionRunning() {
        try {
            return this.txManager.getTransaction() != null;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    @Deprecated
    public final <T> T getManagementBean(Class<T> type) {
        return this.getSingleManagementBean(type);
    }

    @Override
    public final <T> T getSingleManagementBean(Class<T> type) {
        Iterator<T> beans = this.getManagementBeans(type).iterator();
        if (beans.hasNext()) {
            T bean = beans.next();
            if (beans.hasNext()) {
                throw new NotFoundException("More than one management bean for " + type.getName());
            }
            return bean;
        }
        return null;
    }

    protected boolean isEphemeral() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getStoreDir() + "]";
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return GlobalGraphOperations.at(this).getAllNodes();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return GlobalGraphOperations.at(this).getAllRelationshipTypes();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.registerKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.registerTransactionEventHandler(handler);
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.unregisterKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.unregisterTransactionEventHandler(handler);
    }

    @Override
    public Node createNode() {
        return this.nodeManager.createNode();
    }

    @Override
    public Node getNodeById(long id) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new NotFoundException("Node[" + id + "]");
        }
        return this.nodeManager.getNodeById(id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        if (id < 0L || id > MAX_RELATIONSHIP_ID) {
            throw new NotFoundException("Relationship[" + id + "]");
        }
        return this.nodeManager.getRelationshipById(id);
    }

    @Override
    public Node getReferenceNode() {
        return this.nodeManager.getReferenceNode();
    }

    @Override
    public TransactionBuilder tx() {
        return this.defaultTxBuilder;
    }

    @Override
    public Guard getGuard() {
        return this.guard;
    }

    @Override
    public <T> Collection<T> getManagementBeans(Class<T> beanClass) {
        KernelExtension jmx = Service.load(KernelExtension.class, "kernel jmx");
        if (jmx != null) {
            Method getManagementBeans = null;
            Object state = jmx.getState(this.extensions);
            if (state != null) {
                try {
                    getManagementBeans = state.getClass().getMethod("getManagementBeans", Class.class);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (getManagementBeans != null) {
                try {
                    Collection result = (Collection)getManagementBeans.invoke(state, beanClass);
                    if (result == null) {
                        return Collections.emptySet();
                    }
                    return result;
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getTargetException();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        throw new UnsupportedOperationException("Neo4j JMX support not enabled");
    }

    @Override
    public KernelData getKernelData() {
        return this.extensions;
    }

    @Override
    public IndexManager index() {
        return this.indexManager;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public XaDataSourceManager getXaDataSourceManager() {
        return this.xaDataSourceManager;
    }

    @Override
    public TransactionManager getTxManager() {
        return this.txManager;
    }

    @Override
    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.relationshipTypeHolder;
    }

    @Override
    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    @Override
    public DiagnosticsManager getDiagnosticsManager() {
        return this.diagnosticsManager;
    }

    @Override
    public PersistenceSource getPersistenceSource() {
        return this.persistenceSource;
    }

    @Override
    public final StringLogger getMessageLog() {
        return this.msgLog;
    }

    @Override
    public KernelPanicEventGenerator getKernelPanicGenerator() {
        return this.kernelPanicEventGenerator;
    }

    private List<Class<?>> getSettingsClasses() {
        ArrayList settingsClasses = new ArrayList();
        settingsClasses.add(GraphDatabaseSettings.class);
        for (KernelExtension kernelExtension : this.kernelExtensions) {
            Class settingsClass = kernelExtension.getSettingsClass();
            if (settingsClass == null) continue;
            settingsClasses.add(settingsClass);
        }
        return settingsClasses;
    }

    private String canonicalize(String path) {
        try {
            return new File(path).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            return new File(path).getAbsolutePath();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AbstractGraphDatabase)) {
            return false;
        }
        AbstractGraphDatabase that = (AbstractGraphDatabase)o;
        if (this.getStoreId() != null ? !this.getStoreId().equals(that.getStoreId()) : that.getStoreId() != null) {
            return false;
        }
        return this.storeDir.equals(that.storeDir);
    }

    public int hashCode() {
        return this.storeDir.hashCode();
    }

    private class ConfigurationChangedRestarter
    extends LifecycleAdapter {
        private final ConfigurationChangeListener listener = new ConfigurationChangeListener(){
            Executor executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("Database configuration restart"));

            @Override
            public void notifyConfigurationChanges(final Iterable<ConfigurationChange> change) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractGraphDatabase.this.life.stop();
                            AbstractGraphDatabase.this.life.start();
                            AbstractGraphDatabase.this.msgLog.logMessage("Database restarted with the following configuration changes:" + change);
                        }
                        catch (LifecycleException e) {
                            AbstractGraphDatabase.this.msgLog.logMessage("Could not restart database", e);
                        }
                    }
                });
            }
        };

        private ConfigurationChangedRestarter() {
        }

        @Override
        public void start() throws Throwable {
            AbstractGraphDatabase.this.config.addConfigurationChangeListener(this.listener);
        }

        @Override
        public void stop() throws Throwable {
            AbstractGraphDatabase.this.config.removeConfigurationChangeListener(this.listener);
        }
    }

    class StuffToDoAfterRecovery
    implements Lifecycle {
        StuffToDoAfterRecovery() {
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
            AbstractGraphDatabase.this.storeId = AbstractGraphDatabase.this.neoDataSource.getStoreId();
            KernelDiagnostics.register(AbstractGraphDatabase.this.diagnosticsManager, AbstractGraphDatabase.this, AbstractGraphDatabase.this.neoDataSource);
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
        }
    }

    class DatabaseAvailability
    implements Lifecycle {
        DatabaseAvailability() {
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
            AbstractGraphDatabase.this.msgLog.logMessage("Started - database is now available");
        }

        @Override
        public void stop() throws Throwable {
            AbstractGraphDatabase.this.msgLog.logMessage("Stopping - database is now unavailable");
        }

        @Override
        public void shutdown() throws Throwable {
        }
    }

    class DatabaseStartup
    implements Lifecycle {
        DatabaseStartup() {
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
        }
    }

    class DependencyResolverImpl
    implements DependencyResolver {
        DependencyResolverImpl() {
        }

        @Override
        public <T> T resolveDependency(Class<T> type) {
            if (type.equals(Map.class)) {
                return (T)AbstractGraphDatabase.this.getConfig().getParams();
            }
            if (type.equals(Config.class)) {
                return (T)AbstractGraphDatabase.this.getConfig();
            }
            if (GraphDatabaseService.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this;
            }
            if (TransactionManager.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.txManager;
            }
            if (LockManager.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.lockManager;
            }
            if (LockReleaser.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.lockReleaser;
            }
            if (StoreFactory.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.storeFactory;
            }
            if (StringLogger.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.msgLog;
            }
            if (IndexStore.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.indexStore;
            }
            if (XaFactory.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.xaFactory;
            }
            if (XaDataSourceManager.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.xaDataSourceManager;
            }
            if (FileSystemAbstraction.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.fileSystem;
            }
            if (Guard.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.guard;
            }
            throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
        }
    }

    private class DefaultTxEventSyncHookFactory
    implements TxEventSyncHookFactory {
        private DefaultTxEventSyncHookFactory() {
        }

        @Override
        public TransactionEventsSyncHook create() {
            return AbstractGraphDatabase.this.transactionEventHandlers.hasHandlers() ? new TransactionEventsSyncHook(AbstractGraphDatabase.this.nodeManager, AbstractGraphDatabase.this.transactionEventHandlers, AbstractGraphDatabase.this.txManager) : null;
        }
    }

    private class DefaultKernelExtensionLoader
    implements Lifecycle {
        private final KernelData extensions;
        private Collection<KernelExtension<?>> loaded;

        public DefaultKernelExtensionLoader(KernelData extensions) {
            this.extensions = extensions;
        }

        @Override
        public void init() throws Throwable {
            this.loaded = this.extensions.loadExtensionConfigurations(AbstractGraphDatabase.this.logging.getLogger("neo4j.extension"), AbstractGraphDatabase.this.kernelExtensions);
            this.loadIndexImplementations(AbstractGraphDatabase.this.indexManager, AbstractGraphDatabase.this.logging.getLogger("neo4j.index"));
        }

        @Override
        public void start() throws Throwable {
            this.extensions.loadExtensions(this.loaded, AbstractGraphDatabase.this.logging.getLogger("neo4j.extension"));
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
        }

        void loadIndexImplementations(IndexManagerImpl indexes, StringLogger msgLog) {
            for (IndexProvider index : AbstractGraphDatabase.this.indexProviders) {
                try {
                    indexes.addProvider(index.identifier(), index.load(new DependencyResolverImpl()));
                }
                catch (Throwable cause) {
                    msgLog.logMessage("Failed to load index provider " + index.identifier(), cause);
                    if (this.isAnUpgradeProblem(cause)) {
                        throw Exceptions.launderedException(cause);
                    }
                    cause.printStackTrace();
                }
            }
        }

        private boolean isAnUpgradeProblem(Throwable cause) {
            while (cause != null) {
                if (cause instanceof Throwable) {
                    return true;
                }
                cause = cause.getCause();
            }
            return false;
        }
    }

    protected class DefaultKernelData
    extends KernelData
    implements Lifecycle {
        private final Config config;
        private final GraphDatabaseAPI graphDb;

        public DefaultKernelData(Config config, GraphDatabaseAPI graphDb) {
            this.config = config;
            this.graphDb = graphDb;
        }

        @Override
        public Version version() {
            return Version.getKernel();
        }

        @Override
        public Config getConfig() {
            return this.config;
        }

        @Override
        public Map<String, String> getConfigParams() {
            return this.config.getParams();
        }

        @Override
        public GraphDatabaseAPI graphDatabase() {
            return this.graphDb;
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
            this.shutdown(AbstractGraphDatabase.this.msgLog);
        }
    }

    public static class Configuration {
        public static final GraphDatabaseSetting.BooleanSetting dump_configuration = GraphDatabaseSettings.dump_configuration;
        public static final GraphDatabaseSetting.BooleanSetting read_only = GraphDatabaseSettings.read_only;
        public static final GraphDatabaseSetting.BooleanSetting use_memory_mapped_buffers = GraphDatabaseSettings.use_memory_mapped_buffers;
        public static final GraphDatabaseSetting.BooleanSetting execution_guard_enabled = GraphDatabaseSettings.execution_guard_enabled;
        public static final GraphDatabaseSettings.CacheTypeSetting cache_type = GraphDatabaseSettings.cache_type;
        public static final GraphDatabaseSetting.BooleanSetting load_kernel_extensions = GraphDatabaseSettings.load_kernel_extensions;
        public static final GraphDatabaseSetting.BooleanSetting ephemeral = new GraphDatabaseSetting.BooleanSetting("ephemeral");
        public static final GraphDatabaseSetting.DirectorySetting store_dir = GraphDatabaseSettings.store_dir;
        public static final GraphDatabaseSetting.FileSetting neo_store = GraphDatabaseSettings.neo_store;
        public static final GraphDatabaseSetting.FileSetting logical_log = GraphDatabaseSettings.logical_log;
    }
}

