/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.impl.cache.CacheProvider;

public final class EmbeddedReadOnlyGraphDatabase
extends AbstractGraphDatabase {
    private static Map<String, String> readOnlyParams = new HashMap<String, String>();

    public EmbeddedReadOnlyGraphDatabase(String storeDir) {
        this(storeDir, readOnlyParams);
    }

    public EmbeddedReadOnlyGraphDatabase(String storeDir, Map<String, String> params) {
        this(storeDir, params, Service.load(IndexProvider.class), Service.load(KernelExtension.class), Service.load(CacheProvider.class));
    }

    public EmbeddedReadOnlyGraphDatabase(String storeDir, Map<String, String> params, Iterable<IndexProvider> indeProviders, Iterable<KernelExtension> kernelExtensions, Iterable<CacheProvider> cacheProviders) {
        super(storeDir, EmbeddedReadOnlyGraphDatabase.addReadOnly(params), indeProviders, kernelExtensions, cacheProviders);
        this.run();
    }

    private static Map<String, String> addReadOnly(Map<String, String> params) {
        params.putAll(readOnlyParams);
        return params;
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    static {
        readOnlyParams.put(GraphDatabaseSettings.read_only.name(), "true");
    }
}

