/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import org.neo4j.kernel.impl.nioneo.store.Abstract64BitRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;

public class LegacyDynamicRecord
extends Abstract64BitRecord {
    private byte[] data = null;
    private char[] charData = null;
    private int length;
    private long prevBlock = Record.NO_PREV_BLOCK.intValue();
    private long nextBlock = Record.NO_NEXT_BLOCK.intValue();
    private int type;

    public LegacyDynamicRecord(long id) {
        super(id);
    }

    public int getType() {
        return this.type;
    }

    void setType(int type) {
        this.type = type;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setInUse(boolean inUse) {
        super.setInUse(inUse);
        if (!inUse) {
            this.data = null;
        }
    }

    public void setInUse(boolean inUse, int type) {
        this.type = type;
        this.setInUse(inUse);
    }

    public void setData(byte[] data) {
        this.length = data.length;
        this.data = data;
    }

    public void setCharData(char[] data) {
        this.length = data.length * 2;
        this.charData = data;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        assert (this.charData == null);
        return this.data;
    }

    public boolean isCharData() {
        return this.charData != null;
    }

    public char[] getDataAsChar() {
        assert (this.data == null);
        return this.charData;
    }

    public long getPrevBlock() {
        return this.prevBlock;
    }

    public void setPrevBlock(long prevBlock) {
        this.prevBlock = prevBlock;
    }

    public long getNextBlock() {
        return this.nextBlock;
    }

    public void setNextBlock(long nextBlock) {
        this.nextBlock = nextBlock;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DynamicRecord[").append(this.getId()).append(",").append(this.inUse());
        if (this.inUse()) {
            buf.append(",").append(this.prevBlock).append(",").append(this.data.length).append(",").append(this.nextBlock).append("]");
        }
        return buf.toString();
    }
}

