/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.channels.FileChannel;
import java.util.LinkedList;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.transaction.LockException;

abstract class LockableWindow
implements PersistenceWindow {
    private OperationType type = null;
    private final FileChannel fileChannel;
    private Thread lockingThread = null;
    private final LinkedList<LockElement> waitingThreadList = new LinkedList();
    private int lockCount = 0;
    private int marked = 0;

    @Override
    public abstract Buffer getBuffer();

    @Override
    public abstract long position();

    @Override
    public abstract int size();

    @Override
    public abstract void force();

    @Override
    public abstract void close();

    LockableWindow(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    boolean encapsulates(long position) {
        return this.position() <= position && position < this.position() + (long)this.size();
    }

    FileChannel getFileChannel() {
        return this.fileChannel;
    }

    OperationType getOperationType() {
        return this.type;
    }

    protected abstract void writeOut();

    void setOperationType(OperationType type) {
        this.type = type;
    }

    synchronized void mark() {
        ++this.marked;
    }

    synchronized boolean isMarked() {
        return this.marked > 0;
    }

    synchronized void lock() {
        Thread currentThread = Thread.currentThread();
        LockElement le = new LockElement(currentThread);
        while (this.lockCount > 0 && this.lockingThread != currentThread) {
            this.waitingThreadList.addFirst(le);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        ++this.lockCount;
        this.lockingThread = currentThread;
        le.movedOn = true;
        --this.marked;
    }

    synchronized void unLock() {
        Thread currentThread = Thread.currentThread();
        if (this.lockCount == 0) {
            throw new LockException("" + currentThread + " don't have window lock on " + this);
        }
        --this.lockCount;
        if (this.lockCount == 0) {
            LockElement le;
            this.lockingThread = null;
            if (this.waitingThreadList.size() > 0 && !(le = this.waitingThreadList.removeLast()).movedOn) {
                le.thread.interrupt();
            }
        }
    }

    synchronized int getWaitingThreadsCount() {
        return this.waitingThreadList.size();
    }

    private static class LockElement {
        private final Thread thread;
        private boolean movedOn = false;

        LockElement(Thread thread) {
            this.thread = thread;
        }
    }
}

